/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.commons.handler;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.commons.datasource.BaseDataSource;
import com.digiwin.commons.datasource.ClickHouseDataSource;
import com.digiwin.commons.datasource.DB2ServerDataSource;
import com.digiwin.commons.datasource.DamengDataSource;
import com.digiwin.commons.datasource.GreenplumDataSource;
import com.digiwin.commons.datasource.HiveDataSource;
import com.digiwin.commons.datasource.ImpalaDataSource;
import com.digiwin.commons.datasource.KingBaseDataSource;
import com.digiwin.commons.datasource.MySQLDataSource;
import com.digiwin.commons.datasource.OracleDataSource;
import com.digiwin.commons.datasource.PostgreDataSource;
import com.digiwin.commons.datasource.SQLServerDataSource;
import com.digiwin.commons.datasource.SparkDataSource;
import com.digiwin.commons.datasource.StarRocksDataSource;
import com.digiwin.commons.entity.enums.DbType;
import com.digiwin.commons.entity.enums.Status;
import com.digiwin.commons.entity.model.DataSource;
import com.digiwin.commons.entity.model.TGwFieldMapperingVO;
import com.digiwin.commons.entity.model.ds.FieldInfo;
import com.digiwin.commons.entity.model.ds.Property;
import com.digiwin.commons.entity.model.ds.TDapField;
import com.digiwin.commons.entity.model.ds.TableColumn;
import com.digiwin.commons.entity.vo.dap.TDapFieldVo;
import com.digiwin.commons.entity.vo.dap.TDapTableInfoVo;
import com.digiwin.commons.entity.vo.dap.TDapTableVO;
import com.digiwin.commons.exceptions.BusinessException;
import com.digiwin.commons.utils.CollectionUtils;
import com.digiwin.commons.utils.CommonUtils;
import com.digiwin.commons.utils.PropertyUtils;
import com.digiwin.commons.utils.StringUtils;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ObjectUtils;

public interface BaseDBHandler {
    public static final Logger log = LoggerFactory.getLogger(BaseDBHandler.class);
    public static final String CREATE_TABLE_PREFIX = "CREATE TABLE ";
    public static final String TABLE_NAME = "TABLE_NAME";
    public static final String COLUMN_NAME = "COLUMN_NAME";
    public static final String REMARKS = "REMARKS";
    public static final String TYPE_NAME = "TYPE_NAME";
    public static final String COLUMN_SIZE = "COLUMN_SIZE";
    public static final String CONSTANT_KEY_DATABASE = "database";
    public static final String COMMENT_KEY = "COMMENT";
    public static final String ALTER_TABLE = "ALTER TABLE";
    public static final String ADD_COLUMN = "ADD COLUMN";
    public static final String COLUMN_AFTER = "AFTER";
    public static final String PRIMARY_KEY = "PRIMARY KEY";
    public static final String DUPLICATE_KEY = "DUPLICATE KEY";

    default public Connection getConnection(DbType dbType, String parameter) {
        Connection connection = null;
        BaseDataSource datasource = null;
        try {
            switch (dbType) {
                case POSTGRESQL: {
                    datasource = (BaseDataSource)JSON.parseObject((String)parameter, PostgreDataSource.class);
                    break;
                }
                case KINGBASEES: {
                    datasource = (BaseDataSource)JSON.parseObject((String)parameter, KingBaseDataSource.class);
                    break;
                }
                case DM: {
                    datasource = (BaseDataSource)JSON.parseObject((String)parameter, DamengDataSource.class);
                    break;
                }
                case MYSQL: {
                    datasource = (BaseDataSource)JSON.parseObject((String)parameter, MySQLDataSource.class);
                    break;
                }
                case HIVE: 
                case SPARK: {
                    if (CommonUtils.getKerberosStartupState()) {
                        System.setProperty("java.security.krb5.conf", PropertyUtils.getString("java.security.krb5.conf.path"));
                        Configuration configuration = new Configuration();
                        configuration.set("hadoop.security.authentication", "kerberos");
                        UserGroupInformation.setConfiguration((Configuration)configuration);
                        UserGroupInformation.loginUserFromKeytab((String)PropertyUtils.getString("login.user.keytab.username"), (String)PropertyUtils.getString("login.user.keytab.path"));
                    }
                    datasource = dbType == DbType.HIVE ? (BaseDataSource)JSON.parseObject((String)parameter, HiveDataSource.class) : (BaseDataSource)JSON.parseObject((String)parameter, SparkDataSource.class);
                    Class.forName("org.apache.hive.jdbc.HiveDriver");
                    break;
                }
                case IMPALA: {
                    datasource = (BaseDataSource)JSON.parseObject((String)parameter, ImpalaDataSource.class);
                    Class.forName("com.cloudera.impala.jdbc41.Driver");
                    break;
                }
                case CLICKHOUSE: {
                    datasource = (BaseDataSource)JSON.parseObject((String)parameter, ClickHouseDataSource.class);
                    Class.forName("ru.yandex.clickhouse.ClickHouseDriver");
                    break;
                }
                case ORACLE: {
                    datasource = (BaseDataSource)JSON.parseObject((String)parameter, OracleDataSource.class);
                    break;
                }
                case SQLSERVER: {
                    datasource = (BaseDataSource)JSON.parseObject((String)parameter, SQLServerDataSource.class);
                    break;
                }
                case DB2: {
                    datasource = (BaseDataSource)JSON.parseObject((String)parameter, DB2ServerDataSource.class);
                    break;
                }
                case STARROCKS: {
                    datasource = (BaseDataSource)JSON.parseObject((String)parameter, StarRocksDataSource.class);
                    break;
                }
                case GREENPLUM: {
                    datasource = (BaseDataSource)JSON.parseObject((String)parameter, GreenplumDataSource.class);
                    break;
                }
            }
            if (datasource != null) {
                connection = DriverManager.getConnection(datasource.getJdbcUrl(), datasource.getUser(), datasource.getPassword());
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new BusinessException(Status.DATA_SOURCE_CONNECTION_ERROR, e.getMessage());
        }
        return connection;
    }

    default public void buildColumnByType(StringBuilder sb, TDapFieldVo field, String type) {
        switch (type) {
            case "VARCHAR": {
                sb.append(field.getName()).append(" ").append(type).append("(").append(field.getFieldLength()).append(")");
                break;
            }
            default: {
                sb.append(field.getName()).append(" ").append(type);
            }
        }
    }

    default public void buildColumnComment(StringBuilder sb, TDapFieldVo field) {
        sb.append(" ").append(COMMENT_KEY).append(" ").append("'").append(field.getDescription()).append("'");
    }

    default public void buildColumnSort(StringBuilder sb, TDapFieldVo field, Map<String, String> preColumnMap) {
        sb.append(" ").append(COLUMN_AFTER).append(" ").append(preColumnMap.get(field.getName()));
    }

    /*
     * Exception decompiling
     */
    default public Integer checkTableEmpty(TDapTableVO vo) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    default public String concatCheckTableEmptySql(TDapTableVO vo) {
        return "select count(*) as count from " + vo.getCode() + " limit 1";
    }

    default public String concatTableDeleteSql(TDapTableVO vo) {
        return "DROP TABLE IF EXISTS " + vo.getCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public List<String> queryTableListInDB(String param, String schema, String searchVal, Integer limit, Integer offset) {
        log.info(" {} handler execute query table list , param [{}] ", (Object)this.type().getDesc(), (Object)param);
        ArrayList<String> tables = new ArrayList<String>();
        JSONObject jsonObject = JSON.parseObject((String)param);
        String database = jsonObject.getString(CONSTANT_KEY_DATABASE);
        String sql = !ObjectUtils.isEmpty((Object)limit) && !ObjectUtils.isEmpty((Object)offset) ? String.format("SELECT table_name FROM information_schema.tables WHERE table_schema = '%s' AND table_name LIKE '%s' LIMIT %s OFFSET %s", database, "%".concat(searchVal).concat("%"), offset, (limit - 1) * offset) : String.format("SELECT table_name FROM information_schema.tables WHERE table_schema = '%s' AND table_name LIKE '%s'", database, "%".concat(searchVal).concat("%"));
        try {
            Connection con = this.getConnection(this.type(), param);
            try {
                ResultSet rs = con.createStatement().executeQuery(sql);
                try {
                    while (rs.next()) {
                        String tableName = rs.getString(TABLE_NAME);
                        tables.add(tableName);
                    }
                }
                finally {
                    if (Collections.singletonList(rs).get(0) != null) {
                        rs.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(con).get(0) != null) {
                    con.close();
                }
            }
        }
        catch (SQLException e) {
            log.info(" query table list error , e : {} ", (Throwable)e);
            throw new BusinessException(" query table list error :{0}", e);
        }
        return tables;
    }

    default public List<String> queryFilterTableNames(List<String> tables, String searchVal, Integer pageNo, Integer pageSize) {
        List<String> tableList = new ArrayList<String>();
        if (StringUtils.isNotBlank(searchVal)) {
            tableList = tables.stream().filter(table -> table.contains(searchVal)).collect(Collectors.toList());
        } else {
            tableList.addAll(tables);
        }
        return CollectionUtils.subList(tableList, pageNo, pageSize);
    }

    default public Integer queryTableCount(String param, String schema) {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public List<FieldInfo> queryTableFields(String param, String schema, String dbName, String tableName) {
        ArrayList<FieldInfo> fieldInfos = new ArrayList<FieldInfo>();
        try {
            ResultSet resultSet = this.getDbColumnResultSet(param, schema, dbName, tableName);
            try {
                while (resultSet.next()) {
                    FieldInfo fieldInfoVo = new FieldInfo();
                    fieldInfos.add(fieldInfoVo);
                    fieldInfoVo.setColumnName(resultSet.getString(COLUMN_NAME));
                    fieldInfoVo.setRemarks(resultSet.getString(REMARKS));
                    fieldInfoVo.setTypeName(resultSet.getString(TYPE_NAME));
                    fieldInfoVo.setColumnSize(resultSet.getInt(COLUMN_SIZE));
                }
            }
            finally {
                if (Collections.singletonList(resultSet).get(0) != null) {
                    resultSet.close();
                }
            }
        }
        catch (Exception e) {
            log.info(" query table list error , e : {} ", (Throwable)e);
            throw new BusinessException(" query table list error :{0}", e);
        }
        return fieldInfos;
    }

    default public ResultSet getDbColumnResultSet(String param, String schema, String dbName, String tableName) throws Exception {
        Connection con = this.getConnection(this.type(), param);
        DatabaseMetaData metaData = con.getMetaData();
        ResultSet resultSet = metaData.getColumns(null, schema, tableName, null);
        return resultSet;
    }

    default public List<TGwFieldMapperingVO> queryTableField(String param, String tableName, String dbName, String schema) {
        log.info(" {} handler execute query table field,table : [{}] , param [{}] ", new Object[]{this.type().getDesc(), tableName, param});
        JSONObject jsonObject = JSON.parseObject((String)param);
        String database = jsonObject.getString(CONSTANT_KEY_DATABASE);
        List<FieldInfo> fieldInfos = this.queryTableFields(param, schema, database, tableName);
        return TGwFieldMapperingVO.convertFromFieldInfoList(fieldInfos);
    }

    /*
     * Exception decompiling
     */
    default public boolean checkTableExist(TDapTableVO vo) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    default public List<Map<String, Object>> executeQuery(String param, String sql) {
        log.info(" execute query,sql : [{}] , param [{}] ", (Object)sql, (Object)param);
        ArrayList<Map<String, Object>> list = new ArrayList();
        try (Connection conn = this.getConnection(this.type(), param);
             ResultSet resultSet = conn.createStatement().executeQuery(sql);){
            list = this.analysisResultSet(resultSet);
        }
        catch (Exception e) {
            log.error(" {} execute query sql error, e : {} ", (Object)this.type().getDesc(), (Object)e);
            throw new BusinessException("execute query sql error error : {0}", e);
        }
        return list;
    }

    /*
     * Exception decompiling
     */
    default public List<TableColumn> getColumnByExecuteSql(String param, String sql, String schema) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    default public List<Map<String, Object>> analysisResultSet(ResultSet rs) throws SQLException {
        int i;
        LinkedHashMap<String, String> row;
        ResultSetMetaData md = rs.getMetaData();
        int columnCount = md.getColumnCount();
        ArrayList<Map<String, Object>> lists = new ArrayList<Map<String, Object>>();
        if (columnCount <= 0) {
            log.error("columnCount is {}", (Object)columnCount);
            return new ArrayList<Map<String, Object>>();
        }
        while (rs.next()) {
            row = new LinkedHashMap<String, String>();
            for (i = 1; i <= columnCount; ++i) {
                String columnLabel = md.getColumnLabel(i);
                Object object = rs.getObject(columnLabel);
                if (!ObjectUtils.isEmpty((Object)object)) continue;
                object = "";
            }
            lists.add(row);
        }
        if (CollectionUtils.isEmpty(lists)) {
            row = new LinkedHashMap();
            for (i = 1; i <= columnCount; ++i) {
                row.put(md.getColumnLabel(i), "");
            }
            lists.add(row);
        }
        return lists;
    }

    default public List<TableColumn> analysisResultColumn(ResultSet rs) throws SQLException {
        ResultSetMetaData md = rs.getMetaData();
        int columnCount = md.getColumnCount();
        ArrayList<TableColumn> lists = new ArrayList<TableColumn>();
        if (columnCount <= 0) {
            log.error("columnCount is {}", (Object)columnCount);
            return new ArrayList<TableColumn>();
        }
        for (int i = 1; i <= columnCount; ++i) {
            lists.add(TableColumn.builder().columnName(md.getColumnName(i)).alias(md.getColumnLabel(i)).columnType(md.getColumnTypeName(i)).build());
        }
        return lists;
    }

    default public List<Property> getPartitionFieldsForTable(String param, String tableName) {
        return Collections.emptyList();
    }

    default public List<String> concatUpdateColumnKeySql(TDapTableVO vo, List<TDapFieldVo> oldFieldList, List<TDapField> fullFieldList) {
        return new ArrayList<String>();
    }

    public DbType type();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public List<String> getPrimaryKey(String param, String tableName, String dbName) {
        ArrayList<String> primaryKeys = new ArrayList<String>();
        try {
            Connection conn = this.getConnection(this.type(), param);
            try {
                DatabaseMetaData metaData = conn.getMetaData();
                ResultSet pk = metaData.getPrimaryKeys(null, dbName, tableName);
                try {
                    while (pk.next()) {
                        primaryKeys.add(pk.getString(COLUMN_NAME));
                    }
                }
                finally {
                    if (Collections.singletonList(pk).get(0) != null) {
                        pk.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(conn).get(0) != null) {
                    conn.close();
                }
            }
        }
        catch (Exception e) {
            log.info(" get primary keys error , e : {} ", (Throwable)e);
        }
        return primaryKeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public List<TDapTableInfoVo> queryTablePrimaryKeys(String param, String schema, List<String> tables) {
        ArrayList<TDapTableInfoVo> tableInfoVos = new ArrayList<TDapTableInfoVo>();
        try {
            Connection conn = this.getConnection(this.type(), param);
            try {
                DatabaseMetaData metaData = conn.getMetaData();
                ResultSet pk = null;
                try {
                    for (String table : tables) {
                        pk = metaData.getPrimaryKeys(null, schema, table);
                        ArrayList<String> primaryKeys = new ArrayList<String>();
                        TDapTableInfoVo vo = new TDapTableInfoVo();
                        tableInfoVos.add(vo);
                        vo.setTable(table);
                        vo.setPrimaryKeyList(primaryKeys);
                        while (pk.next()) {
                            primaryKeys.add(pk.getString(COLUMN_NAME));
                        }
                    }
                }
                finally {
                    if (Collections.singletonList(pk).get(0) != null) {
                        pk.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(conn).get(0) != null) {
                    conn.close();
                }
            }
        }
        catch (Exception e) {
            log.info(" get primary keys error , e : {} ", (Throwable)e);
            throw new BusinessException(" get primary keys error  ");
        }
        return tableInfoVos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public List<String> getSchemas(String param) {
        ArrayList<String> schemas = new ArrayList<String>();
        try {
            Connection conn = this.getConnection(this.type(), param);
            try {
                DatabaseMetaData metaData = conn.getMetaData();
                ResultSet schemasResultSet = metaData.getSchemas();
                try {
                    switch (this.type()) {
                        case MYSQL: {
                            schemasResultSet = metaData.getCatalogs();
                            break;
                        }
                        default: {
                            schemasResultSet = metaData.getSchemas();
                        }
                    }
                    while (schemasResultSet.next()) {
                        schemas.add(schemasResultSet.getString(1));
                    }
                }
                finally {
                    if (Collections.singletonList(schemasResultSet).get(0) != null) {
                        schemasResultSet.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(conn).get(0) != null) {
                    conn.close();
                }
            }
        }
        catch (Exception e) {
            log.info(" query schema list error , e : {} ", (Throwable)e);
            throw new BusinessException(Status.QUERY_SCHEMA_LIST_ERROR);
        }
        return schemas;
    }

    default public String getSeparator(DataSource dest, String destTable) {
        return null;
    }

    default public String getLocation(DataSource dest, String destTable) {
        return null;
    }

    default public String replaceSymbols(String sql) {
        return sql;
    }

    default public void buildKeysSqlInfo(List<TDapFieldVo> keyList, StringBuilder sb, String setKeyword) {
        Optional.ofNullable(keyList).filter(CollectionUtils::isNotEmpty).ifPresent(k -> {
            sb.append(setKeyword).append(" ").append("(");
            keyList.forEach(i -> sb.append(i.getName()).append(","));
            StringUtils.removeLastComma(sb);
            sb.append(")").append(" ");
        });
    }
}

