/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.commons.entity.enums;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.digiwin.commons.annotation.EnumDict;
import com.digiwin.commons.utils.StringUtils;

public enum AssignmentTaskType {
    SUB_PROCESS(0, "sub_process"),
    SQL(1, "sql"),
    SHELL(2, "shell"),
    PYTHON(3, "python"),
    MR(4, "mr"),
    SPARK(5, "spark"),
    PROCEDURE(6, "procedure"),
    DEPENDENT(7, "dependent"),
    FLINK(8, "flink"),
    HTTP(9, "http"),
    DATAX(10, "datax"),
    CONDITIONS(11, "conditions"),
    SQOOP(12, "sqoop"),
    GATEWAY(13, "gateway"),
    API_SYNC(14, "api_sync"),
    CDC_SYNC(15, "cdc_sync"),
    ESP_SYNC(16, "esp_sync"),
    DATA_QUALITY(17, "data_quality"),
    STARROCKS_SQL(18, "starrocks_sql"),
    HIVE_SQL(19, "hive_sql"),
    METADATA_COLLECTION(20, "metadata_collection"),
    DATA_GATHER(21, "DATA_GATHER"),
    AUTOML(22, "AUTOML"),
    DATA_PROCESS(23, "DATA_PROCESS"),
    CDC_PATH(44, "$.tasks[type='CDC_SYNC']");

    @EnumValue
    @EnumDict(value=0)
    private final int code;
    @EnumDict(value=1)
    private final String descp;

    private AssignmentTaskType(int code, String descp) {
        this.code = code;
        this.descp = descp;
    }

    public static boolean typeIsNormalTask(String typeName) {
        AssignmentTaskType taskType = AssignmentTaskType.valueOf(typeName);
        return taskType != SUB_PROCESS && taskType != DEPENDENT;
    }

    public int getCode() {
        return this.code;
    }

    public String getDescp() {
        return this.descp;
    }

    public static boolean checkCustomType(String name) {
        if (StringUtils.isNotBlank(name)) {
            return false;
        }
        return AssignmentTaskType.checkCustomType(AssignmentTaskType.valueOf((String)name.toLowerCase()).code);
    }

    public static boolean checkCustomType(Integer number) {
        if (number == null) {
            return false;
        }
        return number > 12 && number != 18 && number != 19;
    }
}

