/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.commons.processor.assets;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.commons.entity.enums.Status;
import com.digiwin.commons.entity.model.Result;
import com.digiwin.commons.entity.model.ds.TDsAssetsOperationRecord;
import com.digiwin.commons.entity.model.es.DocDelete;
import com.digiwin.commons.entity.model.es.DocInsert;
import com.digiwin.commons.entity.vo.assets.DataAssetsVO;
import com.digiwin.commons.entity.vo.ds.ProcessDefinitionVO;
import com.digiwin.commons.exceptions.BusinessException;
import com.digiwin.commons.feign.client.DaasService;
import com.digiwin.commons.feign.client.DsService;
import com.digiwin.commons.utils.JSONUtils;
import feign.Request;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(name={"data.assets.enable"}, havingValue="true", matchIfMissing=true)
public class DataAssetsBaseProcessor<T> {
    private static final Logger log = LoggerFactory.getLogger(DataAssetsBaseProcessor.class);
    public final String DEFAULT_PROJECT_NAME = "default";
    @Autowired
    private DaasService daasService;
    @Autowired
    private DsService dsService;

    public void save(T t) {
    }

    public void remove(Object obj) {
    }

    public void update(T t) {
    }

    public void carryOut(Integer id) {
    }

    public void carryOut(T t) {
    }

    public void copy(Object obj) {
    }

    public T getToEsArgs(Object ... dataParam) {
        return null;
    }

    public Integer getDataId(Object ... dataParam) {
        return null;
    }

    public List<Integer> getDataIdList(Object ... dataParam) {
        return null;
    }

    public Integer getRemoveDataId(Object ... dataParam) {
        return null;
    }

    public Integer getCopyDataId(Object ... dataParam) {
        return null;
    }

    public List<Integer> getRemoveDataIdList(Object ... dataParam) {
        return null;
    }

    public Integer getCarryOutId(Object ... dataParam) {
        return null;
    }

    public List<Integer> getCarryOutIdList(Object ... dataParam) {
        return null;
    }

    public List<Integer> getCopyIdList(Object ... dataParam) {
        return null;
    }

    public Integer getDataIdByResult(Object result) {
        Result paramResult = JSONUtils.parseObject(JSONUtils.toJson(result), Result.class);
        return Integer.valueOf(String.valueOf(paramResult.getData()));
    }

    public void bindCatalog(T t) {
    }

    public void bindCatalogByUpdate(T t) {
        this.bindCatalog(t);
    }

    public void unbindCatalog(Object[] args) {
    }

    public void dataSaveEs(String key, DataAssetsVO dataAssetsVO) {
        HashMap<String, JSONObject> dataJsonMap = new HashMap<String, JSONObject>();
        dataJsonMap.put(key, JSONUtils.parseObject(JSONUtils.toJson(dataAssetsVO)));
        DocInsert docInsert = new DocInsert();
        docInsert.setIndex("dmp_full_data_idx");
        docInsert.setDataJsonMap(dataJsonMap);
        this.daasService.saveEsInfo(docInsert, new Request.Options(3L, TimeUnit.SECONDS, 8L, TimeUnit.SECONDS, true));
    }

    public void dataRemoveEs(String keyId) {
        DocDelete docDelete = new DocDelete();
        docDelete.setIndex("dmp_full_data_idx");
        ArrayList<String> dataList = new ArrayList<String>();
        dataList.add(keyId);
        docDelete.setDataList(dataList);
        this.daasService.deleteEsInfo(docDelete, new Request.Options(3L, TimeUnit.SECONDS, 8L, TimeUnit.SECONDS, true));
    }

    public void compensateAssetsToEsErrorDataSave(TDsAssetsOperationRecord tDsAssetsOperationRecord) {
    }

    public void compensateAssetsToEsErrorDataUpdate(TDsAssetsOperationRecord tDsAssetsOperationRecord) {
    }

    public void compensateAssetsToEsErrorDataDelete(TDsAssetsOperationRecord tDsAssetsOperationRecord) {
    }

    public ProcessDefinitionVO queryProcessDefinitionById(Integer dataId) {
        Result<ProcessDefinitionVO> processDefinitionVOResult = this.dsService.queryByDefinitionId(dataId);
        log.info("query process definition info :{} ", (Object)JSONUtils.toJson(processDefinitionVOResult));
        Optional.ofNullable(processDefinitionVOResult).ifPresent(definitionVOResult -> {
            if (!definitionVOResult.getCode().equals(Status.SUCCESS.getCode())) {
                log.error("query ds definition info error\uff01errorInfo:{}", (Object)definitionVOResult.getMsg());
                throw new BusinessException(Status.QUERY_DEFINITION_INFO_ERROR);
            }
        });
        return processDefinitionVOResult.getData();
    }
}

