/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.commons.service.impl;

import com.digiwin.commons.entity.dto.llm.LlmWorkflowsDTO;
import com.digiwin.commons.entity.dto.llm.LlmWorkflowsInputsDTO;
import com.digiwin.commons.entity.model.llm.LlmCommonResult;
import com.digiwin.commons.entity.model.llm.LlmWorkflow;
import com.digiwin.commons.feign.client.LlmService;
import com.digiwin.commons.service.LlmBusinessService;
import com.digiwin.commons.utils.JSONUtils;
import com.digiwin.commons.utils.StringUtils;
import feign.Request;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(name={"llm.feign.enable"}, havingValue="true")
public class LlmBusinessServiceImpl
implements LlmBusinessService {
    private static final Logger log = LoggerFactory.getLogger(LlmBusinessServiceImpl.class);
    @Autowired
    private LlmService llmService;
    @Value(value="${llm.api.log.api-key}")
    private String workFlowLogApiKey;

    @Override
    public LlmCommonResult<LlmWorkflow> queryLlmWorkflow(String workflowLog) {
        LlmWorkflowsInputsDTO input = LlmWorkflowsInputsDTO.builder().log(workflowLog).build();
        LlmWorkflowsDTO llmWorkflowsDTO = LlmWorkflowsDTO.builder().inputs(input).response_mode("blocking").user("system").build();
        log.info("invoke query llm work flow log:{}", (Object)JSONUtils.toJson(llmWorkflowsDTO));
        String appKey = "Bearer " + this.workFlowLogApiKey;
        String result = this.llmService.queryLlmWorkflow(llmWorkflowsDTO, appKey, new Request.Options(10L, TimeUnit.SECONDS, 100L, TimeUnit.SECONDS, true));
        log.info("invoke query llm work flow log result:{}", (Object)JSONUtils.toJson(result));
        if (StringUtils.isBlank(result)) {
            log.info("result is empty");
            return new LlmCommonResult<LlmWorkflow>();
        }
        return JSONUtils.parseObject(result, LlmCommonResult.class);
    }

    @Override
    public LlmCommonResult<LlmWorkflow> queryAutomlAIAnaByLlmWorkflow(Map<String, String> paramsMap) {
        LlmWorkflowsInputsDTO input = LlmWorkflowsInputsDTO.builder().model_info(paramsMap.get("model_info")).prediction_results(paramsMap.get("prediction_results")).build();
        LlmWorkflowsDTO llmWorkflowsDTO = LlmWorkflowsDTO.builder().inputs(input).response_mode("blocking").user("system").build();
        log.info("invoke query AutomlAI llm work flow log:{}", (Object)JSONUtils.toJson(llmWorkflowsDTO));
        String appKey = "Bearer " + this.workFlowLogApiKey;
        String result = this.llmService.queryLlmWorkflow(llmWorkflowsDTO, appKey, new Request.Options(10L, TimeUnit.SECONDS, 100L, TimeUnit.SECONDS, true));
        log.info("invoke query AutomlAI llm work flow log result:{}", (Object)JSONUtils.toJson(result));
        if (StringUtils.isBlank(result)) {
            log.info("result AutomlAI is empty");
            return new LlmCommonResult<LlmWorkflow>();
        }
        return JSONUtils.parseObject(result, LlmCommonResult.class);
    }
}

