/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.commons.utils;

import com.digiwin.commons.entity.enums.DataSecurityRuleType;
import com.digiwin.commons.entity.model.security.TDsDataSecurityRuleConfig;
import com.digiwin.commons.exceptions.BusinessException;
import com.digiwin.commons.processor.security.EncryptRule;
import com.digiwin.commons.processor.security.HideRule;
import com.digiwin.commons.processor.security.ReplaceRule;
import com.digiwin.commons.processor.security.SubstringRule;
import com.digiwin.commons.utils.StringUtils;
import java.util.function.BiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TDapDataSecurityUtils {
    public static final Logger logger = LoggerFactory.getLogger(TDapDataSecurityUtils.class);

    public static BiFunction<TDsDataSecurityRuleConfig, String, String> getDataSecurityFunction(DataSecurityRuleType type) throws BusinessException {
        switch (type) {
            case HIDE_RULE: {
                return HideRule::hideFunction;
            }
            case REPLACE_RULE: {
                return ReplaceRule::replaceFunction;
            }
            case SUBSTRING_RULE: {
                return SubstringRule::substringFunction;
            }
            case ENCRYPT_RULE: {
                return EncryptRule::encryptFunction;
            }
        }
        throw new BusinessException("invalid type");
    }

    public static String doDataSecurityFunctionByAesKey(DataSecurityRuleType type, TDsDataSecurityRuleConfig ruleConfig, String originalData, String aesKey) throws BusinessException {
        if (StringUtils.isBlank(originalData)) {
            return originalData;
        }
        originalData = originalData.trim();
        switch (type) {
            case HIDE_RULE: {
                return HideRule.hideFunction(ruleConfig, originalData);
            }
            case REPLACE_RULE: {
                return ReplaceRule.replaceFunction(ruleConfig, originalData);
            }
            case SUBSTRING_RULE: {
                return SubstringRule.substringFunction(ruleConfig, originalData);
            }
            case ENCRYPT_RULE: {
                return EncryptRule.encryptFunction(ruleConfig, originalData, aesKey);
            }
        }
        throw new BusinessException("invalid type");
    }

    public static String doDataSecurityFunction(DataSecurityRuleType ruleType, TDsDataSecurityRuleConfig config, String originalData) {
        if (StringUtils.isBlank(originalData)) {
            return originalData;
        }
        originalData = originalData.trim();
        BiFunction<TDsDataSecurityRuleConfig, String, String> dataSecurityFunction = TDapDataSecurityUtils.getDataSecurityFunction(ruleType);
        return dataSecurityFunction.apply(config, originalData);
    }

    public static String doDataSecurityDecryptFunction(TDsDataSecurityRuleConfig config, String aesSecretKey, String originalData) {
        if (StringUtils.isBlank(originalData)) {
            return originalData;
        }
        originalData = originalData.trim();
        config.setAesSecretKey(aesSecretKey);
        return EncryptRule.decryptFunction(config, originalData);
    }
}

