/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.commons.datasource;

import com.digiwin.commons.datasource.BaseDataSource;
import com.digiwin.commons.datasource.ClickHouseDataSource;
import com.digiwin.commons.datasource.DB2ServerDataSource;
import com.digiwin.commons.datasource.DamengDataSource;
import com.digiwin.commons.datasource.GreenplumDataSource;
import com.digiwin.commons.datasource.HiveDataSource;
import com.digiwin.commons.datasource.ImpalaDataSource;
import com.digiwin.commons.datasource.KingBaseDataSource;
import com.digiwin.commons.datasource.MySQLDataSource;
import com.digiwin.commons.datasource.OracleDataSource;
import com.digiwin.commons.datasource.PostgreDataSource;
import com.digiwin.commons.datasource.SQLServerDataSource;
import com.digiwin.commons.datasource.SparkDataSource;
import com.digiwin.commons.datasource.StarRocksDataSource;
import com.digiwin.commons.entity.enums.DbType;
import com.digiwin.commons.utils.JSONUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSourceFactory {
    private static final Logger logger = LoggerFactory.getLogger(DataSourceFactory.class);

    public static BaseDataSource getDatasource(DbType dbType, String parameter) {
        try {
            switch (dbType) {
                case MYSQL: {
                    return JSONUtils.parseObject(parameter, MySQLDataSource.class);
                }
                case POSTGRESQL: {
                    return JSONUtils.parseObject(parameter, PostgreDataSource.class);
                }
                case HIVE: {
                    return JSONUtils.parseObject(parameter, HiveDataSource.class);
                }
                case IMPALA: {
                    return JSONUtils.parseObject(parameter, ImpalaDataSource.class);
                }
                case SPARK: {
                    return JSONUtils.parseObject(parameter, SparkDataSource.class);
                }
                case CLICKHOUSE: {
                    return JSONUtils.parseObject(parameter, ClickHouseDataSource.class);
                }
                case ORACLE: {
                    return JSONUtils.parseObject(parameter, OracleDataSource.class);
                }
                case SQLSERVER: {
                    return JSONUtils.parseObject(parameter, SQLServerDataSource.class);
                }
                case DB2: {
                    return JSONUtils.parseObject(parameter, DB2ServerDataSource.class);
                }
                case STARROCKS: {
                    return JSONUtils.parseObject(parameter, StarRocksDataSource.class);
                }
                case GREENPLUM: {
                    return JSONUtils.parseObject(parameter, GreenplumDataSource.class);
                }
                case DM: {
                    return JSONUtils.parseObject(parameter, DamengDataSource.class);
                }
                case KINGBASEES: {
                    return JSONUtils.parseObject(parameter, KingBaseDataSource.class);
                }
            }
            return null;
        }
        catch (Exception e) {
            logger.error("get datasource object error", (Throwable)e);
            return null;
        }
    }

    public static void loadClass(DbType dbType) throws Exception {
        switch (dbType) {
            case MYSQL: 
            case STARROCKS: {
                Class.forName("com.mysql.jdbc.Driver");
                break;
            }
            case POSTGRESQL: 
            case GREENPLUM: {
                Class.forName("org.postgresql.Driver");
                break;
            }
            case IMPALA: {
                Class.forName("com.cloudera.impala.jdbc41.Driver");
                break;
            }
            case HIVE: {
                Class.forName("org.apache.hive.jdbc.HiveDriver");
                break;
            }
            case SPARK: {
                Class.forName("org.apache.hive.jdbc.HiveDriver");
                break;
            }
            case CLICKHOUSE: {
                Class.forName("ru.yandex.clickhouse.ClickHouseDriver");
                break;
            }
            case ORACLE: {
                Class.forName("oracle.jdbc.driver.OracleDriver");
                break;
            }
            case SQLSERVER: {
                Class.forName("com.microsoft.sqlserver.jdbc.SQLServerDriver");
                break;
            }
            case DB2: {
                Class.forName("com.ibm.db2.jcc.DB2Driver");
                break;
            }
            default: {
                logger.error("not support sql type: {},can't load class", (Object)dbType);
                throw new IllegalArgumentException("not support sql type,can't load class");
            }
        }
    }

    public static String[] getHostsAndPort(String address, String separator) {
        String[] result = new String[2];
        String[] tmpArray = address.split(separator);
        String hostsAndPorts = tmpArray[tmpArray.length - 1];
        StringBuilder hosts = new StringBuilder();
        String[] hostPortArray = hostsAndPorts.split(",");
        String port = hostPortArray[0].split(":")[1];
        for (String hostPort : hostPortArray) {
            hosts.append(hostPort.split(":")[0]).append(",");
        }
        hosts.deleteCharAt(hosts.length() - 1);
        result[0] = hosts.toString();
        result[1] = port;
        return result;
    }
}

