/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.commons.entity.enums;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.digiwin.commons.annotation.EnumDict;
import java.util.Arrays;
import org.apache.commons.lang.StringUtils;

public enum LineageDbType {
    MYSQL(0, "mysql", 1),
    POSTGRESQL(1, "postgres", 1),
    HIVE(2, "hive", 4),
    SPARK(3, "sparksql", 4),
    CLICKHOUSE(4, "clickhouse", 4),
    ORACLE(5, "oracle", 1),
    SQLSERVER(6, "mysql", 1),
    DB2(7, "db2", 1),
    IMPALA(8, "hive", 4),
    ES(9, "non-validating", 3),
    STARROCKS(10, "mysql", 4),
    GREENPLUM(11, "greenplum", 1),
    KAFKA(12, "non-validating", 2),
    DM(13, "mysql", 1),
    KINGBASEES(14, "mysql", 1),
    STANDARD(-1, "non-validating", 0);

    @EnumValue
    @EnumDict(value=0)
    private final int code;
    @EnumDict(value=1)
    private final String desc;
    private final int type;

    private LineageDbType(int code, String desc, int type) {
        this.code = code;
        this.desc = desc;
        this.type = type;
    }

    public static LineageDbType of(int type) {
        for (LineageDbType ty : LineageDbType.values()) {
            if (ty.getCode() != type) continue;
            return ty;
        }
        return null;
    }

    public static LineageDbType of(String desc) {
        for (LineageDbType ty : LineageDbType.values()) {
            if (!StringUtils.equals((String)ty.getDesc(), (String)desc)) continue;
            return ty;
        }
        return null;
    }

    public static Enum<LineageDbType> indexOf(Integer index) {
        return Arrays.stream(LineageDbType.values()).filter(i -> i.ordinal() == index.intValue()).findAny().orElse(null);
    }

    public int getType() {
        return this.type;
    }

    public int getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }
}

