/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.commons.entity.enums;

import org.springframework.util.ObjectUtils;

public enum TrackingType {
    CREATE(1, "create"),
    DELETE(2, "delete"),
    UPDATE(3, "update"),
    SELECT(4, "select"),
    RELEASE(5, "release"),
    DOWNLOAD(6, "download"),
    ONLINE(7, "online"),
    OFFLINE(8, "offline"),
    LOGIN(20, "login"),
    LOGIN_OUT(21, "login out"),
    IMPORT(22, "import"),
    EXPORT(23, "export"),
    TABLE_CARRY_OUT(24, "table carry out"),
    AUTH(25, "auth some resource"),
    UN_AUTH(26, "unauth some resource"),
    AUTHORIZE(50, "authorize api"),
    BATCHUPDATE(51, "batch update"),
    PUBLICKEY(52, "get the RSA encryption public key"),
    DOC(53, "get the SDK documentation for encrypted transmission"),
    JAR(54, "get the SDK jar for encrypted transmission"),
    COPY(55, "copy"),
    STATE(56, "start or stop process"),
    SCHEDULE(57, "schedule"),
    PROJECT_MEMBER_UPDATE(58, "project member update"),
    PROJECT_ADMIN_UPDATE(59, "project admin update"),
    RESOURCE_CREATE_DIRECTORY(60, "resource create directory"),
    RESOURCE_UPDATE_CONTENT(61, "resource update content"),
    RESOURCE_VIEW(62, "resource view"),
    STRATEGIC_MANAGEMENT(70, "dataservice Strategic Management"),
    AUTH_DATASERVICE(71, "auth dataservice"),
    ROLLBACK(72, "rollback"),
    OTHER(99, "other tracking type");

    private final int code;
    private final String desc;

    private TrackingType(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static Integer code(String name) {
        if (name == null) {
            return null;
        }
        for (TrackingType ty : TrackingType.values()) {
            if (!ObjectUtils.nullSafeEquals((Object)ty.name(), (Object)name)) continue;
            return ty.getCode();
        }
        return null;
    }

    public static TrackingType of(String desc) {
        for (TrackingType ty : TrackingType.values()) {
            if (!ObjectUtils.nullSafeEquals((Object)ty.getDesc(), (Object)desc)) continue;
            return ty;
        }
        return null;
    }

    public static Integer of(int type) {
        for (TrackingType ty : TrackingType.values()) {
            if (ty.getCode() != type) continue;
            return ty.getCode();
        }
        return null;
    }

    public int getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }
}

