/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.commons.handler;

import com.digiwin.commons.entity.enums.DbType;
import com.digiwin.commons.exceptions.BusinessException;
import com.digiwin.commons.handler.BaseDBHandler;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@Component
public class DmDBHandler
implements BaseDBHandler {
    private static final Logger log = LoggerFactory.getLogger(DmDBHandler.class);

    @Override
    public DbType type() {
        return DbType.DM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> queryTableListInDB(String param, String schema, String searchVal, Integer limit, Integer offset) {
        log.info("DM {} handler execute query table list , param [{}] ", (Object)this.type().getDesc(), (Object)param);
        ArrayList<String> tables = new ArrayList<String>();
        String sql = !ObjectUtils.isEmpty((Object)limit) && !ObjectUtils.isEmpty((Object)offset) ? String.format("select TABLE_NAME  from dba_tables  where owner= '%s' AND TABLE_NAME LIKE '%s' LIMIT %s OFFSET %s", schema, "%".concat(searchVal).concat("%"), offset, (limit - 1) * offset) : String.format("select TABLE_NAME  from dba_tables  where owner= '%s' AND table_name LIKE '%s'", schema, "%".concat(searchVal).concat("%"));
        try {
            Connection con = this.getConnection(this.type(), param);
            try {
                ResultSet rs = con.createStatement().executeQuery(sql);
                try {
                    while (rs.next()) {
                        String tableName = rs.getString("TABLE_NAME");
                        tables.add(tableName);
                    }
                }
                finally {
                    if (Collections.singletonList(rs).get(0) != null) {
                        rs.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(con).get(0) != null) {
                    con.close();
                }
            }
        }
        catch (SQLException e) {
            log.info(" query table list error , e : {} ", (Throwable)e);
            throw new BusinessException(" query table list error :{0}", e);
        }
        return tables;
    }
}

