/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.commons.entity.enums;

import org.springframework.util.ObjectUtils;

public enum TranslationType {
    SIMPLIFIED_TO_TRADITIONAL(0, "zh2Hant", "\u7b80\u4f53\u8f6c\u5316\u7e41\u4f53"),
    TRADITIONAL_TO_SIMPLIFIED(1, "zh2Hans", "\u7e41\u4f53\u8f6c\u5316\u7b80\u4f53");

    private final int code;
    private final String type;
    private final String description;

    private TranslationType(int code, String type, String description) {
        this.code = code;
        this.type = type;
        this.description = description;
    }

    public static Integer code(String name) {
        if (name == null) {
            return null;
        }
        for (TranslationType ty : TranslationType.values()) {
            if (!ObjectUtils.nullSafeEquals((Object)ty.name(), (Object)name)) continue;
            return ty.getCode();
        }
        return null;
    }

    public static Integer of(int type) {
        for (TranslationType ty : TranslationType.values()) {
            if (ty.getCode() != type) continue;
            return ty.getCode();
        }
        return null;
    }

    public static TranslationType get(int type) {
        for (TranslationType ty : TranslationType.values()) {
            if (ty.getCode() != type) continue;
            return ty;
        }
        return null;
    }

    public int getCode() {
        return this.code;
    }

    public String getType() {
        return this.type;
    }

    public String getDescription() {
        return this.description;
    }
}

