/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.jdbc.executor;

import com.digiwin.jdbc.config.DatabaseConfig;
import com.digiwin.jdbc.executor.BaseQueryExecutor;
import com.digiwin.jdbc.factory.DatabaseStrategyFactory;
import com.digiwin.jdbc.model.QueryResult;
import com.digiwin.jdbc.strategy.BaseDatabaseStrategy;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcQueryExecutor
extends BaseQueryExecutor {
    private static final Logger log = LoggerFactory.getLogger(JdbcQueryExecutor.class);
    private static final String DEFAULT_KEY = "default";
    private Map<String, BaseDatabaseStrategy> strategies = new HashMap<String, BaseDatabaseStrategy>();

    public JdbcQueryExecutor(Map<String, DatabaseConfig> dataSourceConfigs) {
        super(dataSourceConfigs);
    }

    private BaseDatabaseStrategy getOrCreateStrategy(String dataSourceName) throws Exception {
        if (!this.strategies.containsKey(dataSourceName)) {
            DatabaseConfig config = (DatabaseConfig)this.dataSourceConfigs.get(dataSourceName);
            if (config == null) {
                throw new IllegalArgumentException("\u672a\u627e\u5230\u6570\u636e\u6e90\u914d\u7f6e: " + dataSourceName);
            }
            BaseDatabaseStrategy strategy = DatabaseStrategyFactory.createStrategy(config);
            this.strategies.put(dataSourceName, strategy);
        }
        return this.strategies.get(dataSourceName);
    }

    private String getDefaultDataSourceName() {
        if (this.dataSourceConfigs.size() == 1) {
            return (String)this.dataSourceConfigs.keySet().iterator().next();
        }
        return DEFAULT_KEY;
    }

    @Override
    public QueryResult executeQuery(String sql) throws Exception {
        return this.executeQuery(sql, null);
    }

    @Override
    public QueryResult executeQuery(String sql, Map<String, Object> params) throws Exception {
        QueryResult queryResult;
        String dsName = this.getDefaultDataSourceName();
        logger.debug("\u6267\u884cJDBC\u67e5\u8be2 [\u6570\u636e\u6e90: {}]: {}", (Object)dsName, (Object)sql);
        long startTime = System.currentTimeMillis();
        BaseDatabaseStrategy strategy = null;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            strategy = this.getOrCreateStrategy(dsName);
            conn = strategy.buildJdbcConnection();
            stmt = conn.prepareStatement(sql);
            this.setStatementParameters(stmt, params);
            rs = stmt.executeQuery();
            QueryResult result = this.buildQueryResult(rs, startTime);
            logger.debug("JDBC\u67e5\u8be2\u6267\u884c\u6210\u529f [\u6570\u636e\u6e90: {}], \u8017\u65f6: {} ms, \u8fd4\u56de {} \u6761\u8bb0\u5f55", new Object[]{dsName, result.getQueryTime(), result.getTotalCount()});
            queryResult = result;
        }
        catch (Exception e) {
            try {
                logger.error("\u6267\u884cJDBC\u67e5\u8be2\u65f6\u53d1\u751f\u9519\u8bef [\u6570\u636e\u6e90: {}]: {}", new Object[]{dsName, e.getMessage(), e});
                throw new Exception("Failed to execute JDBC query: " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                this.closeResourceQuietly(rs);
                this.closeResourceQuietly(stmt);
                throw throwable;
            }
        }
        this.closeResourceQuietly(rs);
        this.closeResourceQuietly(stmt);
        return queryResult;
    }

    @Override
    public int executeUpdate(String sql) throws Exception {
        return this.executeUpdate(sql, null);
    }

    @Override
    public int executeUpdate(String sql, Map<String, Object> params) throws Exception {
        int n;
        String dsName = this.getDefaultDataSourceName();
        logger.debug("\u6267\u884cJDBC\u66f4\u65b0\u64cd\u4f5c [\u6570\u636e\u6e90: {}]: {}", (Object)dsName, (Object)sql);
        BaseDatabaseStrategy strategy = null;
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            strategy = this.getOrCreateStrategy(dsName);
            conn = strategy.buildJdbcConnection();
            stmt = conn.prepareStatement(sql);
            this.setStatementParameters(stmt, params);
            int result = stmt.executeUpdate();
            logger.debug("JDBC\u66f4\u65b0\u64cd\u4f5c\u6267\u884c\u6210\u529f [\u6570\u636e\u6e90: {}], \u5f71\u54cd {} \u884c", (Object)dsName, (Object)result);
            n = result;
        }
        catch (Exception e) {
            try {
                logger.error("\u6267\u884cJDBC\u66f4\u65b0\u64cd\u4f5c\u65f6\u53d1\u751f\u9519\u8bef [\u6570\u636e\u6e90: {}]: {}", new Object[]{dsName, e.getMessage(), e});
                throw new Exception("Failed to execute JDBC update: " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                this.closeResourceQuietly(stmt);
                throw throwable;
            }
        }
        this.closeResourceQuietly(stmt);
        return n;
    }

    @Override
    public int[] executeBatch(List<String> sqlList) throws Exception {
        int[] nArray;
        String dsName = this.getDefaultDataSourceName();
        logger.debug("\u6267\u884cJDBC\u6279\u5904\u7406\u64cd\u4f5c [\u6570\u636e\u6e90: {}], \u5171 {} \u6761SQL", (Object)dsName, (Object)sqlList.size());
        BaseDatabaseStrategy strategy = null;
        Connection conn = null;
        Statement stmt = null;
        try {
            strategy = this.getOrCreateStrategy(dsName);
            conn = strategy.buildJdbcConnection();
            stmt = conn.createStatement();
            for (String sql : sqlList) {
                stmt.addBatch(sql);
            }
            int[] result = stmt.executeBatch();
            logger.debug("JDBC\u6279\u5904\u7406\u64cd\u4f5c\u6267\u884c\u6210\u529f [\u6570\u636e\u6e90: {}]", (Object)dsName);
            nArray = result;
        }
        catch (Exception e) {
            try {
                logger.error("\u6267\u884cJDBC\u6279\u5904\u7406\u64cd\u4f5c\u65f6\u53d1\u751f\u9519\u8bef [\u6570\u636e\u6e90: {}]: {}", new Object[]{dsName, e.getMessage(), e});
                throw new Exception("Failed to execute JDBC batch: " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                this.closeResourceQuietly(stmt);
                throw throwable;
            }
        }
        this.closeResourceQuietly(stmt);
        return nArray;
    }

    @Override
    public boolean testConnection() {
        String dsName = this.getDefaultDataSourceName();
        return this.testConnection(dsName);
    }

    @Override
    public boolean testConnection(String dataSourceName) {
        logger.debug("\u6d4b\u8bd5JDBC\u6570\u636e\u5e93\u8fde\u63a5 [\u6570\u636e\u6e90: {}]", (Object)dataSourceName);
        try {
            BaseDatabaseStrategy strategy = this.getOrCreateStrategy(dataSourceName);
            boolean result = strategy.testJdbcConnection();
            logger.debug("JDBC\u6570\u636e\u5e93\u8fde\u63a5\u6d4b\u8bd5\u7ed3\u679c [\u6570\u636e\u6e90: {}]: {}", (Object)dataSourceName, (Object)(result ? "\u6210\u529f" : "\u5931\u8d25"));
            return result;
        }
        catch (Exception e) {
            logger.error("\u6d4b\u8bd5JDBC\u6570\u636e\u5e93\u8fde\u63a5\u65f6\u53d1\u751f\u9519\u8bef [\u6570\u636e\u6e90: {}]: {}", new Object[]{dataSourceName, e.getMessage(), e});
            return false;
        }
    }

    @Override
    public void close() {
        logger.debug("\u5173\u95edJDBC\u67e5\u8be2\u6267\u884c\u5668\u8d44\u6e90");
        for (Map.Entry<String, BaseDatabaseStrategy> entry : this.strategies.entrySet()) {
            try {
                entry.getValue().close();
            }
            catch (Exception e) {
                logger.warn("\u5173\u95ed\u6570\u636e\u6e90 {} \u65f6\u53d1\u751f\u9519\u8bef: {}", new Object[]{entry.getKey(), e.getMessage(), e});
            }
        }
        this.strategies.clear();
    }

    @Override
    public Connection getConnection(String dataSourceName) throws Exception {
        BaseDatabaseStrategy strategy = this.getOrCreateStrategy(dataSourceName);
        return strategy.buildJdbcConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Map<String, Object>> getTableMeta(String dataSourceName, String tableName) throws Exception {
        ArrayList<Map<String, Object>> arrayList;
        logger.debug("\u83b7\u53d6\u8868 {} \u7684\u5143\u6570\u636e\u4fe1\u606f [\u6570\u636e\u6e90: {}]", (Object)tableName, (Object)dataSourceName);
        Connection conn = this.getConnection(dataSourceName);
        ResultSet rs = null;
        try {
            DatabaseMetaData metaData = conn.getMetaData();
            rs = metaData.getColumns(null, null, tableName, null);
            ArrayList<Map<String, Object>> metaList = new ArrayList<Map<String, Object>>();
            while (rs.next()) {
                LinkedHashMap<String, Object> columnInfo = new LinkedHashMap<String, Object>();
                columnInfo.put("TABLE_NAME", rs.getString("TABLE_NAME"));
                columnInfo.put("COLUMN_NAME", rs.getString("COLUMN_NAME"));
                columnInfo.put("TYPE_NAME", rs.getString("TYPE_NAME"));
                columnInfo.put("COLUMN_SIZE", rs.getInt("COLUMN_SIZE"));
                columnInfo.put("DECIMAL_DIGITS", rs.getInt("DECIMAL_DIGITS"));
                columnInfo.put("NULLABLE", rs.getInt("NULLABLE"));
                columnInfo.put("REMARKS", rs.getString("REMARKS"));
                metaList.add(columnInfo);
            }
            logger.debug("\u6210\u529f\u83b7\u53d6\u8868 {} \u7684\u5143\u6570\u636e\u4fe1\u606f [\u6570\u636e\u6e90: {}], \u5171 {} \u5217", new Object[]{tableName, dataSourceName, metaList.size()});
            arrayList = metaList;
        }
        catch (Throwable throwable) {
            this.closeResourceQuietly(rs);
            throw throwable;
        }
        this.closeResourceQuietly(rs);
        return arrayList;
    }

    public QueryResult executeQueryOnDataSource(String dataSourceName, String sql, Map<String, Object> params) throws Exception {
        QueryResult queryResult;
        logger.debug("\u6267\u884cJDBC\u67e5\u8be2 [\u6570\u636e\u6e90: {}]: {}", (Object)dataSourceName, (Object)sql);
        long startTime = System.currentTimeMillis();
        BaseDatabaseStrategy strategy = null;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            strategy = this.getOrCreateStrategy(dataSourceName);
            conn = strategy.buildJdbcConnection();
            stmt = conn.prepareStatement(sql);
            this.setStatementParameters(stmt, params);
            rs = stmt.executeQuery();
            QueryResult result = this.buildQueryResult(rs, startTime);
            logger.debug("JDBC\u67e5\u8be2\u6267\u884c\u6210\u529f [\u6570\u636e\u6e90: {}], \u8017\u65f6: {} ms", (Object)dataSourceName, (Object)result.getQueryTime());
            queryResult = result;
        }
        catch (Exception e) {
            try {
                logger.error("\u6267\u884cJDBC\u67e5\u8be2\u65f6\u53d1\u751f\u9519\u8bef [\u6570\u636e\u6e90: {}]: {}", new Object[]{dataSourceName, e.getMessage(), e});
                throw new Exception("Failed to execute JDBC query on data source " + dataSourceName + ": " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                this.closeResourceQuietly(rs);
                this.closeResourceQuietly(stmt);
                throw throwable;
            }
        }
        this.closeResourceQuietly(rs);
        this.closeResourceQuietly(stmt);
        return queryResult;
    }

    public int executeUpdateOnDataSource(String dataSourceName, String sql, Map<String, Object> params) throws Exception {
        int n;
        logger.debug("\u6267\u884cJDBC\u66f4\u65b0\u64cd\u4f5c [\u6570\u636e\u6e90: {}]: {}", (Object)dataSourceName, (Object)sql);
        BaseDatabaseStrategy strategy = null;
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            strategy = this.getOrCreateStrategy(dataSourceName);
            conn = strategy.buildJdbcConnection();
            stmt = conn.prepareStatement(sql);
            this.setStatementParameters(stmt, params);
            int result = stmt.executeUpdate();
            logger.debug("JDBC\u66f4\u65b0\u64cd\u4f5c\u6267\u884c\u6210\u529f [\u6570\u636e\u6e90: {}], \u5f71\u54cd {} \u884c", (Object)dataSourceName, (Object)result);
            n = result;
        }
        catch (Exception e) {
            try {
                logger.error("\u6267\u884cJDBC\u66f4\u65b0\u64cd\u4f5c\u65f6\u53d1\u751f\u9519\u8bef [\u6570\u636e\u6e90: {}]: {}", new Object[]{dataSourceName, e.getMessage(), e});
                throw new Exception("Failed to execute JDBC update on data source " + dataSourceName + ": " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                this.closeResourceQuietly(stmt);
                throw throwable;
            }
        }
        this.closeResourceQuietly(stmt);
        return n;
    }
}

