/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.jdbc.strategy.databaseStrategy;

import com.digiwin.jdbc.config.DatabaseConfig;
import com.digiwin.jdbc.model.DatabaseType;
import com.digiwin.jdbc.strategy.BaseDatabaseStrategy;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgreSQLStrategy
extends BaseDatabaseStrategy {
    private static final Logger log = LoggerFactory.getLogger(PostgreSQLStrategy.class);
    private static final String POSTGRESQL_RECOMMENDED_PARAMS = "useUnicode=true&characterEncoding=UTF-8&ssl=false&ApplicationName=MultiDBTools";

    public PostgreSQLStrategy(DatabaseConfig config) {
        super(config);
    }

    @Override
    public DatabaseType getDatabaseType() {
        return DatabaseType.POSTGRESQL;
    }

    @Override
    public String buildJdbcUrl() {
        StringBuilder url = new StringBuilder();
        url.append("jdbc:postgresql://").append(this.config.getHost()).append(":").append(this.config.getPort()).append("/").append(this.config.getDatabase());
        String params = this.buildUrlParams(POSTGRESQL_RECOMMENDED_PARAMS);
        if (!params.isEmpty()) {
            url.append("?").append(params);
        }
        return url.toString();
    }

    @Override
    public String buildCalciteUrl() {
        return this.buildJdbcUrl();
    }

    private String buildUrlParams(String additionalParams) {
        StringBuilder params = new StringBuilder();
        if (this.config.getProperties() != null) {
            for (Map.Entry<String, String> entry : this.config.getProperties().entrySet()) {
                params.append(entry.getKey()).append("=").append(entry.getValue()).append("&");
            }
        }
        if (additionalParams != null && !additionalParams.isEmpty()) {
            params.append(additionalParams);
            if (!additionalParams.endsWith("&")) {
                params.append("&");
            }
        }
        if (params.length() > 0 && params.charAt(params.length() - 1) == '&') {
            params.deleteCharAt(params.length() - 1);
        }
        return params.toString();
    }
}

