/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.commons.entity.enums.jdbc;

import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.dialect.CalciteSqlDialect;
import org.apache.calcite.sql.dialect.Db2SqlDialect;
import org.apache.calcite.sql.dialect.HiveSqlDialect;
import org.apache.calcite.sql.dialect.MssqlSqlDialect;
import org.apache.calcite.sql.dialect.MysqlSqlDialect;
import org.apache.calcite.sql.dialect.OracleSqlDialect;
import org.apache.calcite.sql.dialect.PostgresqlSqlDialect;

public enum DatabaseType {
    MYSQL("mysql", "com.mysql.cj.jdbc.Driver", MysqlSqlDialect.DEFAULT),
    ORACLE("oracle", "oracle.jdbc.driver.OracleDriver", OracleSqlDialect.DEFAULT),
    SQLSERVER("sqlserver", "com.microsoft.sqlserver.jdbc.SQLServerDriver", MssqlSqlDialect.DEFAULT),
    POSTGRESQL("postgresql", "org.postgresql.Driver", PostgresqlSqlDialect.DEFAULT),
    DB2("db2", "com.ibm.db2.jcc.DB2Driver", Db2SqlDialect.DEFAULT),
    HIVE("hive", "org.apache.hive.jdbc.HiveDriver", HiveSqlDialect.DEFAULT),
    IMPALA("impala", "com.cloudera.impala.jdbc.Driver", HiveSqlDialect.DEFAULT),
    STARROCKS("starrocks", "com.mysql.cj.jdbc.Driver", MysqlSqlDialect.DEFAULT),
    CALCITE("calcite", "org.apache.calcite.jdbc.Driver", CalciteSqlDialect.DEFAULT);

    private final String type;
    private final String driverClass;
    private final SqlDialect sqlDialect;

    public String getType() {
        return this.type;
    }

    public String getDriverClass() {
        return this.driverClass;
    }

    public SqlDialect getSqlDialect() {
        return this.sqlDialect;
    }

    private DatabaseType(String type, String driverClass, SqlDialect sqlDialect) {
        this.type = type;
        this.driverClass = driverClass;
        this.sqlDialect = sqlDialect;
    }
}

