/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.commons.entity.model;

import com.digiwin.commons.entity.enums.Status;
import com.digiwin.commons.exceptions.BusinessException;
import com.digiwin.commons.utils.I18nUtils;
import com.digiwin.commons.utils.MDCUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Result<T> {
    private static final Logger log = LoggerFactory.getLogger(Result.class);
    private Integer code;
    private String msg;
    private T data;
    private String traceId;

    public Result() {
        this.traceId = MDCUtils.fetchTraceID();
    }

    public Result(Integer code, String msg) {
        this.code = code;
        this.msg = msg;
        this.traceId = MDCUtils.fetchTraceID();
    }

    private Result(T data) {
        this.code = Status.SUCCESS.getCode();
        this.msg = I18nUtils.getMessage(Status.SUCCESS.name(), new Object[0]);
        this.data = data;
        this.traceId = MDCUtils.fetchTraceID();
    }

    private Result(String msg, T data) {
        this.code = Status.SUCCESS.getCode();
        this.msg = msg;
        this.data = data;
        this.traceId = MDCUtils.fetchTraceID();
    }

    private Result(Status status) {
        this.traceId = MDCUtils.fetchTraceID();
        if (status != null) {
            this.code = status.getCode();
            this.msg = I18nUtils.getMessage(status.name(), new Object[0]);
        }
    }

    public static <T> Result<T> success(T data) {
        return new Result<T>(data);
    }

    @Deprecated
    public static <T> Result<T> success(String msg, T data) {
        return new Result<T>(msg, data);
    }

    public static <T> Result<T> success(Status status) {
        return new Result<T>(status);
    }

    public static Result success() {
        return new Result(Status.SUCCESS);
    }

    public static <T> Result<T> error(T data) {
        return new Result<T>(data);
    }

    public static Result error(Status status) {
        return new Result(status);
    }

    @Deprecated
    public static Result error(String mes) {
        return new Result(Status.INTERNAL_SERVER_ERROR_ARGS.getCode(), mes);
    }

    @Deprecated
    public static Result error(Integer code, String mes) {
        return new Result(code, mes);
    }

    public static Result error(BusinessException e) {
        return new Result(e.getCode(), e.getMessage());
    }

    public void checkSuccess(Status status) {
        if (!this.getCode().equals(Status.SUCCESS.getCode())) {
            log.error("check result error!msg: {}", (Object)this);
            throw new BusinessException(status);
        }
    }

    public static Result errorWithArgs(Status status, Object ... args) {
        return new Result(status.getCode(), I18nUtils.getMessage(status.name(), args));
    }

    public Integer getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public T getData() {
        return this.data;
    }

    public String getTraceId() {
        return this.traceId;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public void setData(T data) {
        this.data = data;
    }

    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Result)) {
            return false;
        }
        Result other = (Result)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$code = this.getCode();
        Integer other$code = other.getCode();
        if (this$code == null ? other$code != null : !((Object)this$code).equals(other$code)) {
            return false;
        }
        String this$msg = this.getMsg();
        String other$msg = other.getMsg();
        if (this$msg == null ? other$msg != null : !this$msg.equals(other$msg)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        String this$traceId = this.getTraceId();
        String other$traceId = other.getTraceId();
        return !(this$traceId == null ? other$traceId != null : !this$traceId.equals(other$traceId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Result;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : ((Object)$code).hashCode());
        String $msg = this.getMsg();
        result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        String $traceId = this.getTraceId();
        result = result * 59 + ($traceId == null ? 43 : $traceId.hashCode());
        return result;
    }

    public String toString() {
        return "Result(code=" + this.getCode() + ", msg=" + this.getMsg() + ", data=" + this.getData() + ", traceId=" + this.getTraceId() + ")";
    }
}

