/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.commons.factory.jdbc;

import com.digiwin.jdbc.config.DatabaseConfig;
import com.digiwin.jdbc.strategy.BaseDatabaseStrategy;
import com.digiwin.jdbc.strategy.databaseStrategy.DB2Strategy;
import com.digiwin.jdbc.strategy.databaseStrategy.HiveStrategy;
import com.digiwin.jdbc.strategy.databaseStrategy.ImpalaStrategy;
import com.digiwin.jdbc.strategy.databaseStrategy.MySQLStrategy;
import com.digiwin.jdbc.strategy.databaseStrategy.OracleStrategy;
import com.digiwin.jdbc.strategy.databaseStrategy.PostgreSQLStrategy;
import com.digiwin.jdbc.strategy.databaseStrategy.SQLServerStrategy;
import com.digiwin.jdbc.strategy.databaseStrategy.StarRocksStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseStrategyFactory {
    private static final Logger log = LoggerFactory.getLogger(DatabaseStrategyFactory.class);

    public static BaseDatabaseStrategy createStrategy(DatabaseConfig config) {
        if (config == null || config.getType() == null) {
            throw new IllegalArgumentException("\u6570\u636e\u5e93\u914d\u7f6e\u6216\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        log.debug("\u521b\u5efa\u6570\u636e\u5e93\u7b56\u7565: {}", (Object)config.getType());
        switch (config.getType()) {
            case MYSQL: {
                return new MySQLStrategy(config);
            }
            case ORACLE: {
                return new OracleStrategy(config);
            }
            case SQLSERVER: {
                return new SQLServerStrategy(config);
            }
            case POSTGRESQL: {
                return new PostgreSQLStrategy(config);
            }
            case DB2: {
                return new DB2Strategy(config);
            }
            case HIVE: {
                return new HiveStrategy(config);
            }
            case IMPALA: {
                return new ImpalaStrategy(config);
            }
            case STARROCKS: {
                return new StarRocksStrategy(config);
            }
        }
        throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u6570\u636e\u5e93\u7c7b\u578b: " + (Object)((Object)config.getType()));
    }
}

