/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.commons.utils;

import com.digiwin.commons.entity.enums.Status;
import com.digiwin.commons.exceptions.BusinessException;
import com.digiwin.commons.utils.StringUtils;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class FileValidator {
    private static final Logger log = LoggerFactory.getLogger(FileValidator.class);
    private static final String FILENAME_REGEX = "^[^\\\\/]+\\.(xls|xlsx|csv)$";
    private static final long MAX_FILE_SIZE = 0xA00000L;

    public static boolean validateFileFormat(MultipartFile file) {
        String originalFilename = file.getOriginalFilename();
        String fileExtension = originalFilename.substring(originalFilename.lastIndexOf(".") + 1);
        if (StringUtils.isBlank(fileExtension)) {
            log.info("fileExtension is empty");
            throw new BusinessException(Status.FILE_EXTENSION_IS_EMPTY);
        }
        return "xls".equals(fileExtension = fileExtension.toLowerCase()) || "xlsx".equals(fileExtension) || "csv".equals(fileExtension);
    }

    public static boolean validateFilenameSecurity(MultipartFile file) {
        String originalFilename = file.getOriginalFilename();
        if (originalFilename != null) {
            return Pattern.matches(FILENAME_REGEX, originalFilename);
        }
        return false;
    }

    public static boolean validateFileSize(MultipartFile file) {
        return file.getSize() <= 0xA00000L;
    }

    public static void validate(MultipartFile file) {
        if (!FileValidator.validateFileFormat(file)) {
            log.info(Status.FILE_FORMAT_IS_INVALID.getMsg());
            throw new BusinessException(Status.FILE_FORMAT_IS_INVALID);
        }
        if (!FileValidator.validateFilenameSecurity(file)) {
            log.info(Status.FILE_NAME_IS_NOT_SECURITY.getMsg());
            throw new BusinessException(Status.FILE_NAME_IS_NOT_SECURITY);
        }
        if (!FileValidator.validateFileSize(file)) {
            log.info(Status.FILE_EXCEEDING_THE_LIMIT_SIZE.getMsg());
            throw new BusinessException(Status.FILE_EXCEEDING_THE_LIMIT_SIZE);
        }
    }
}

