/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.jdbc.config;

import com.digiwin.commons.entity.enums.jdbc.DatabaseType;
import java.util.HashMap;
import java.util.Map;

public class DatabaseConfig {
    private DatabaseType type;
    private String host;
    private int port;
    private String database;
    private String username;
    private String password;
    private Map<String, String> properties;

    public void addProperty(String key, String value) {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
        this.properties.put(key, value);
    }

    public String getProperty(String key) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(key);
    }

    public boolean containsProperty(String key) {
        if (this.properties == null) {
            return false;
        }
        return this.properties.containsKey(key);
    }

    protected DatabaseConfig(DatabaseConfigBuilder<?, ?> b) {
        this.type = ((DatabaseConfigBuilder)b).type;
        this.host = ((DatabaseConfigBuilder)b).host;
        this.port = ((DatabaseConfigBuilder)b).port;
        this.database = ((DatabaseConfigBuilder)b).database;
        this.username = ((DatabaseConfigBuilder)b).username;
        this.password = ((DatabaseConfigBuilder)b).password;
        this.properties = ((DatabaseConfigBuilder)b).properties;
    }

    public static DatabaseConfigBuilder<?, ?> builder() {
        return new DatabaseConfigBuilderImpl();
    }

    public DatabaseType getType() {
        return this.type;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setType(DatabaseType type) {
        this.type = type;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DatabaseConfig)) {
            return false;
        }
        DatabaseConfig other = (DatabaseConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        DatabaseType this$type = this.getType();
        DatabaseType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        String this$database = this.getDatabase();
        String other$database = other.getDatabase();
        if (this$database == null ? other$database != null : !this$database.equals(other$database)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        Map<String, String> this$properties = this.getProperties();
        Map<String, String> other$properties = other.getProperties();
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DatabaseConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DatabaseType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        result = result * 59 + this.getPort();
        String $database = this.getDatabase();
        result = result * 59 + ($database == null ? 43 : $database.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        Map<String, String> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        return result;
    }

    public String toString() {
        return "DatabaseConfig(type=" + (Object)((Object)this.getType()) + ", host=" + this.getHost() + ", port=" + this.getPort() + ", database=" + this.getDatabase() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", properties=" + this.getProperties() + ")";
    }

    public DatabaseConfig(DatabaseType type, String host, int port, String database, String username, String password, Map<String, String> properties) {
        this.type = type;
        this.host = host;
        this.port = port;
        this.database = database;
        this.username = username;
        this.password = password;
        this.properties = properties;
    }

    public DatabaseConfig() {
    }

    private static final class DatabaseConfigBuilderImpl
    extends DatabaseConfigBuilder<DatabaseConfig, DatabaseConfigBuilderImpl> {
        private DatabaseConfigBuilderImpl() {
        }

        @Override
        protected DatabaseConfigBuilderImpl self() {
            return this;
        }

        @Override
        public DatabaseConfig build() {
            return new DatabaseConfig(this);
        }
    }

    public static abstract class DatabaseConfigBuilder<C extends DatabaseConfig, B extends DatabaseConfigBuilder<C, B>> {
        private DatabaseType type;
        private String host;
        private int port;
        private String database;
        private String username;
        private String password;
        private Map<String, String> properties;

        protected abstract B self();

        public abstract C build();

        public B type(DatabaseType type) {
            this.type = type;
            return this.self();
        }

        public B host(String host) {
            this.host = host;
            return this.self();
        }

        public B port(int port) {
            this.port = port;
            return this.self();
        }

        public B database(String database) {
            this.database = database;
            return this.self();
        }

        public B username(String username) {
            this.username = username;
            return this.self();
        }

        public B password(String password) {
            this.password = password;
            return this.self();
        }

        public B properties(Map<String, String> properties) {
            this.properties = properties;
            return this.self();
        }

        public String toString() {
            return "DatabaseConfig.DatabaseConfigBuilder(type=" + (Object)((Object)this.type) + ", host=" + this.host + ", port=" + this.port + ", database=" + this.database + ", username=" + this.username + ", password=" + this.password + ", properties=" + this.properties + ")";
        }
    }
}

