/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.jdbc.executor;

import com.digiwin.commons.entity.model.QueryResult;
import com.digiwin.jdbc.config.DatabaseConfig;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseQueryExecutor {
    private static final Logger log = LoggerFactory.getLogger(BaseQueryExecutor.class);
    protected static final Logger logger = LoggerFactory.getLogger(BaseQueryExecutor.class);
    protected Map<String, DatabaseConfig> dataSourceConfigs;

    public BaseQueryExecutor(Map<String, DatabaseConfig> dataSourceConfigs) {
        this.dataSourceConfigs = dataSourceConfigs;
    }

    public abstract QueryResult executeQuery(String var1) throws Exception;

    public abstract QueryResult executeQuery(String var1, Map<String, Object> var2) throws Exception;

    public abstract int executeUpdate(String var1) throws Exception;

    public abstract int executeUpdate(String var1, Map<String, Object> var2) throws Exception;

    public abstract boolean testConnection();

    public abstract boolean testConnection(String var1);

    public abstract void close();

    public abstract Connection getConnection(String var1) throws Exception;

    protected List<String> extractColumnNames(ResultSet rs) throws SQLException {
        ArrayList<String> columnNames = new ArrayList<String>();
        int columnCount = rs.getMetaData().getColumnCount();
        for (int i = 1; i <= columnCount; ++i) {
            columnNames.add(rs.getMetaData().getColumnLabel(i));
        }
        return columnNames;
    }

    protected List<Map<String, Object>> extractResultSetData(ResultSet rs) throws SQLException {
        ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>();
        while (rs.next()) {
            LinkedHashMap<String, Object> row = new LinkedHashMap<String, Object>();
            int columnCount = rs.getMetaData().getColumnCount();
            for (int i = 1; i <= columnCount; ++i) {
                String columnName = rs.getMetaData().getColumnLabel(i);
                Object value = rs.getObject(i);
                row.put(columnName, value);
            }
            dataList.add(row);
        }
        return dataList;
    }

    protected void setStatementParameters(PreparedStatement stmt, Map<String, Object> params) throws SQLException {
        if (params == null || params.isEmpty()) {
            return;
        }
        int index = 1;
        for (Object value : params.values()) {
            stmt.setObject(index++, value);
        }
    }

    protected void closeResourceQuietly(AutoCloseable resource) {
        if (resource != null) {
            try {
                resource.close();
            }
            catch (Exception e) {
                logger.warn("\u5173\u95ed\u8d44\u6e90\u65f6\u53d1\u751f\u9519\u8bef: {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    protected QueryResult buildQueryResult(ResultSet rs, long startTime) throws SQLException {
        QueryResult result = new QueryResult();
        result.setColumns(this.extractColumnNames(rs));
        result.setData(this.extractResultSetData(rs));
        result.setQueryTime(System.currentTimeMillis() - startTime);
        result.setSuccess(true);
        result.setMessage("Success");
        return result;
    }

    protected QueryResult buildErrorResult(String errorMessage) {
        QueryResult result = new QueryResult();
        result.setSuccess(false);
        result.setMessage(errorMessage);
        result.setColumns(new ArrayList<String>());
        result.setData(new ArrayList<Map<String, Object>>());
        return result;
    }
}

