/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.jdbc.strategy;

import com.digiwin.commons.entity.enums.jdbc.DatabaseType;
import com.digiwin.commons.entity.model.QueryResult;
import com.digiwin.jdbc.config.DatabaseConfig;
import com.digiwin.jdbc.strategy.SimpleDataSource;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.calcite.sql.SqlDialect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseDatabaseStrategy {
    private static final Logger log = LoggerFactory.getLogger(BaseDatabaseStrategy.class);
    protected static final Logger logger = LoggerFactory.getLogger(BaseDatabaseStrategy.class);
    protected DatabaseConfig config;

    public BaseDatabaseStrategy(DatabaseConfig config) {
        this.config = config;
    }

    public abstract DatabaseType getDatabaseType();

    public abstract String buildJdbcUrl();

    public String buildCalciteUrl() {
        return this.buildJdbcUrl();
    }

    public SqlDialect getSqlDialect() {
        return this.getDatabaseType().getSqlDialect();
    }

    public boolean isCalciteOnly() {
        return this.getDatabaseType().getDriverClass() == null;
    }

    public Connection buildJdbcConnection() throws Exception {
        if (this.isCalciteOnly()) {
            throw new UnsupportedOperationException((Object)((Object)this.getDatabaseType()) + " \u4e0d\u652f\u6301JDBC\u8fde\u63a5\uff0c\u4ec5\u652f\u6301Calcite\u8054\u90a6\u67e5\u8be2");
        }
        try {
            Class.forName(this.getDatabaseType().getDriverClass());
            Connection conn = DriverManager.getConnection(this.buildJdbcUrl(), this.config.getUsername(), this.config.getPassword());
            this.applyConnectionProperties(conn);
            logger.debug("\u6210\u529f\u521b\u5efaJDBC\u8fde\u63a5: {} ({})", (Object)this.getDatabaseType(), (Object)this.config.getHost());
            return conn;
        }
        catch (ClassNotFoundException e) {
            logger.error("\u627e\u4e0d\u5230\u6570\u636e\u5e93\u9a71\u52a8: {}", (Object)this.getDatabaseType().getDriverClass(), (Object)e);
            throw new Exception("\u627e\u4e0d\u5230\u6570\u636e\u5e93\u9a71\u52a8\u7a0b\u5e8f: " + this.getDatabaseType().getDriverClass(), e);
        }
        catch (SQLException e) {
            logger.error("\u6784\u5efaJDBC\u8fde\u63a5\u5931\u8d25: {}", (Object)e.getMessage(), (Object)e);
            throw new Exception("Failed to build JDBC connection: " + e.getMessage(), e);
        }
    }

    public DataSource buildCalciteDataSource() throws Exception {
        if (this.isCalciteOnly()) {
            throw new UnsupportedOperationException((Object)((Object)this.getDatabaseType()) + " \u4e0d\u4f7f\u7528\u4f20\u7edfDataSource\uff0c\u9700\u8981\u4e13\u7528\u7684Schema\u6ce8\u518c\u65b9\u5f0f");
        }
        try {
            Class.forName(this.getDatabaseType().getDriverClass());
            return new SimpleDataSource(this.buildCalciteUrl(), this.config.getUsername(), this.config.getPassword());
        }
        catch (ClassNotFoundException e) {
            logger.error("\u627e\u4e0d\u5230\u6570\u636e\u5e93\u9a71\u52a8: {}", (Object)this.getDatabaseType().getDriverClass(), (Object)e);
            throw new Exception("\u627e\u4e0d\u5230\u6570\u636e\u5e93\u9a71\u52a8\u7a0b\u5e8f: " + this.getDatabaseType().getDriverClass(), e);
        }
    }

    protected void applyConnectionProperties(Connection connection) {
        if (this.config.getProperties() != null) {
            for (Map.Entry<String, String> entry : this.config.getProperties().entrySet()) {
                try {
                    connection.setClientInfo(entry.getKey(), entry.getValue());
                }
                catch (SQLException e) {
                    logger.debug("\u8bbe\u7f6e\u8fde\u63a5\u5c5e\u6027\u5931\u8d25: {} = {}", (Object)entry.getKey(), (Object)entry.getValue());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryResult executeJdbcQuery(String sql, Map<String, Object> params) throws Exception {
        logger.debug("\u6267\u884cJDBC\u67e5\u8be2: {}", (Object)sql);
        Connection conn = null;
        long startTime = System.currentTimeMillis();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.buildJdbcConnection();
            stmt = conn.prepareStatement(sql);
            this.setStatementParameters(stmt, params);
            rs = stmt.executeQuery();
            QueryResult result = new QueryResult();
            result.setColumns(this.extractColumnNames(rs));
            result.setData(this.extractResultSetData(rs));
            result.setQueryTime(System.currentTimeMillis() - startTime);
            result.setSuccess(true);
            result.setMessage("Success");
            logger.debug("JDBC\u67e5\u8be2\u6267\u884c\u6210\u529f\uff0c\u8017\u65f6: {} ms", (Object)result.getQueryTime());
            QueryResult queryResult = result;
            this.closeResourceQuietly(rs);
            this.closeResourceQuietly(stmt);
            this.closeResourceQuietly(conn);
            return queryResult;
        }
        catch (Throwable throwable) {
            this.closeResourceQuietly(rs);
            this.closeResourceQuietly(stmt);
            this.closeResourceQuietly(conn);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryResult executeCalciteQuery(String sql, Map<String, Object> params) throws Exception {
        logger.debug("\u6267\u884cCalcite\u67e5\u8be2: {}", (Object)sql);
        DataSource dataSource = this.buildCalciteDataSource();
        long startTime = System.currentTimeMillis();
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = dataSource.getConnection();
            stmt = conn.prepareStatement(sql);
            this.setStatementParameters(stmt, params);
            rs = stmt.executeQuery();
            QueryResult result = new QueryResult();
            result.setColumns(this.extractColumnNames(rs));
            result.setData(this.extractResultSetData(rs));
            result.setQueryTime(System.currentTimeMillis() - startTime);
            result.setSuccess(true);
            result.setMessage("Success");
            logger.debug("Calcite\u67e5\u8be2\u6267\u884c\u6210\u529f\uff0c\u8017\u65f6: {} ms", (Object)result.getQueryTime());
            QueryResult queryResult = result;
            this.closeResourceQuietly(rs);
            this.closeResourceQuietly(stmt);
            this.closeResourceQuietly(conn);
            return queryResult;
        }
        catch (Throwable throwable) {
            this.closeResourceQuietly(rs);
            this.closeResourceQuietly(stmt);
            this.closeResourceQuietly(conn);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeJdbcUpdate(String sql, Map<String, Object> params) throws Exception {
        logger.debug("\u6267\u884cJDBC\u66f4\u65b0\u64cd\u4f5c: {}", (Object)sql);
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = this.buildJdbcConnection();
            stmt = conn.prepareStatement(sql);
            this.setStatementParameters(stmt, params);
            int result = stmt.executeUpdate();
            logger.debug("JDBC\u66f4\u65b0\u64cd\u4f5c\u6267\u884c\u6210\u529f\uff0c\u5f71\u54cd {} \u884c", (Object)result);
            int n = result;
            this.closeResourceQuietly(stmt);
            this.closeResourceQuietly(conn);
            return n;
        }
        catch (Throwable throwable) {
            this.closeResourceQuietly(stmt);
            this.closeResourceQuietly(conn);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean testJdbcConnection() {
        logger.debug("\u6d4b\u8bd5JDBC\u6570\u636e\u5e93\u8fde\u63a5");
        Connection conn = null;
        try {
            conn = this.buildJdbcConnection();
            boolean bl = conn != null && !conn.isClosed() && conn.isValid(5);
            return bl;
        }
        catch (Exception e) {
            logger.error("\u6d4b\u8bd5JDBC\u6570\u636e\u5e93\u8fde\u63a5\u65f6\u53d1\u751f\u9519\u8bef: {}", (Object)e.getMessage(), (Object)e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.closeResourceQuietly(conn);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean testCalciteConnection() {
        logger.debug("\u6d4b\u8bd5Calcite\u6570\u636e\u5e93\u8fde\u63a5");
        try {
            DataSource dataSource = this.buildCalciteDataSource();
            try (Connection conn = dataSource.getConnection();){
                boolean bl = conn != null && !conn.isClosed() && conn.isValid(5);
                return bl;
            }
        }
        catch (Exception e) {
            logger.error("\u6d4b\u8bd5Calcite\u6570\u636e\u5e93\u8fde\u63a5\u65f6\u53d1\u751f\u9519\u8bef: {}", (Object)e.getMessage(), (Object)e);
            return false;
        }
    }

    public void close() {
        logger.debug("\u5173\u95ed\u6570\u636e\u5e93\u8d44\u6e90");
    }

    public DatabaseConfig getConfig() {
        return this.config;
    }

    protected void setStatementParameters(PreparedStatement stmt, Map<String, Object> params) throws SQLException {
        if (params == null || params.isEmpty()) {
            return;
        }
        int index = 1;
        for (Object value : params.values()) {
            stmt.setObject(index++, value);
        }
    }

    protected List<String> extractColumnNames(ResultSet rs) throws SQLException {
        ArrayList<String> columnNames = new ArrayList<String>();
        int columnCount = rs.getMetaData().getColumnCount();
        for (int i = 1; i <= columnCount; ++i) {
            columnNames.add(rs.getMetaData().getColumnLabel(i));
        }
        return columnNames;
    }

    protected List<Map<String, Object>> extractResultSetData(ResultSet rs) throws SQLException {
        ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>();
        while (rs.next()) {
            LinkedHashMap<String, Object> row = new LinkedHashMap<String, Object>();
            int columnCount = rs.getMetaData().getColumnCount();
            for (int i = 1; i <= columnCount; ++i) {
                String columnName = rs.getMetaData().getColumnLabel(i);
                Object value = rs.getObject(i);
                row.put(columnName, value);
            }
            dataList.add(row);
        }
        return dataList;
    }

    protected void closeResourceQuietly(AutoCloseable resource) {
        if (resource != null) {
            try {
                resource.close();
            }
            catch (Exception e) {
                logger.warn("\u5173\u95ed\u8d44\u6e90\u65f6\u53d1\u751f\u9519\u8bef: {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    protected String buildUrlParams(String additionalParams) {
        StringBuilder params = new StringBuilder();
        if (this.config.getProperties() != null && !this.config.getProperties().isEmpty()) {
            for (Map.Entry<String, String> entry : this.config.getProperties().entrySet()) {
                params.append(entry.getKey()).append("=").append(entry.getValue()).append("&");
            }
        }
        if (additionalParams != null && !additionalParams.isEmpty()) {
            params.append(additionalParams);
            if (!additionalParams.endsWith("&")) {
                params.append("&");
            }
        }
        if (params.length() > 0 && params.charAt(params.length() - 1) == '&') {
            params.deleteCharAt(params.length() - 1);
        }
        return params.toString();
    }

    protected String buildStandardJdbcUrl(String protocol, String defaultParams) {
        StringBuilder url = new StringBuilder("jdbc:");
        url.append(protocol).append("://").append(this.config.getHost()).append(":").append(this.config.getPort()).append("/").append(this.config.getDatabase());
        String params = this.buildUrlParams(defaultParams);
        if (!params.isEmpty()) {
            url.append("?").append(params);
        }
        return url.toString();
    }
}

