/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.jdbc.strategy.databaseStrategy;

import com.digiwin.commons.entity.enums.jdbc.DatabaseType;
import com.digiwin.jdbc.config.DatabaseConfig;
import com.digiwin.jdbc.strategy.BaseDatabaseStrategy;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLServerStrategy
extends BaseDatabaseStrategy {
    private static final Logger log = LoggerFactory.getLogger(SQLServerStrategy.class);

    public SQLServerStrategy(DatabaseConfig config) {
        super(config);
    }

    @Override
    public DatabaseType getDatabaseType() {
        return DatabaseType.SQLSERVER;
    }

    @Override
    public String buildJdbcUrl() {
        StringBuilder url = new StringBuilder("jdbc:sqlserver://");
        url.append(this.config.getHost()).append(":").append(this.config.getPort()).append(";databaseName=").append(this.config.getDatabase());
        if (this.config.getProperties() != null && !this.config.getProperties().isEmpty()) {
            for (Map.Entry<String, String> entry : this.config.getProperties().entrySet()) {
                url.append(";").append(entry.getKey()).append("=").append(entry.getValue());
            }
        }
        return url.toString();
    }
}

