/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dcc.core.util;

import cn.hutool.core.util.IdUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ArrayUtils;

public class StringUtils {
    public static final String EMPTY = "";

    private StringUtils() {
        throw new UnsupportedOperationException("Construct StringUtils");
    }

    public static boolean isEmpty(CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    public static boolean isNotEmpty(CharSequence cs) {
        return !StringUtils.isEmpty(cs);
    }

    public static boolean isBlank(String s) {
        if (StringUtils.isEmpty(s)) {
            return true;
        }
        return s.trim().length() == 0;
    }

    public static boolean isNotBlank(String s) {
        return !StringUtils.isBlank(s);
    }

    public static String replaceNRTtoUnderline(String src) {
        if (StringUtils.isBlank(src)) {
            return src;
        }
        return src.replaceAll("[\n|\r|\t]", "_");
    }

    public static String trim(String str) {
        return str == null ? null : str.trim();
    }

    public static String uuid() {
        return UUID.randomUUID().toString().replace("-", EMPTY);
    }

    public static boolean notNull(Object obj) {
        return Objects.nonNull(obj) && !"null".equals(obj) && StringUtils.isNotBlank(obj.toString());
    }

    public static String getSnowflakeNextIdStr() {
        return IdUtil.getSnowflakeNextIdStr();
    }

    public static String escapeQueryChars(String s) {
        if (StringUtils.isBlank(s)) {
            return EMPTY;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\\' || c == '\'' || c == '!' || c == '(' || c == ')' || c == '^' || c == '[' || c == ']' || c == '\"' || c == '{' || c == '}' || c == '~' || c == '*' || c == '?' || c == '|' || c == '&' || c == ';' || c == '/' || c == '$') {
                sb.append('\\');
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static List<String> matcherPatternWord(String str, String reg) {
        ArrayList<String> results = new ArrayList<String>();
        if (StringUtils.isNotBlank(str)) {
            Pattern pattern = Pattern.compile(reg);
            Matcher matcher = pattern.matcher(str);
            while (matcher.find()) {
                results.add(matcher.group(1));
            }
        }
        return results;
    }

    public static String generateRandomString(int len) {
        String chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
        StringBuilder sb = new StringBuilder(len);
        Random random = new Random();
        for (int i = 0; i < 10; ++i) {
            sb.append(chars.charAt(random.nextInt(chars.length())));
        }
        return sb.toString();
    }

    public static boolean checkEndWith(String orgStr, String checkStr) {
        if (!StringUtils.isEmpty(orgStr) && !StringUtils.isEmpty(checkStr)) {
            return orgStr.endsWith(checkStr);
        }
        return false;
    }

    public static String capitalizeFirstLetter(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        str = str.toLowerCase();
        char firstChar = Character.toUpperCase(str.charAt(0));
        return firstChar + str.substring(1);
    }

    public static boolean equalsAnyIgnoreCase(CharSequence string, CharSequence ... searchStrings) {
        if (ArrayUtils.isNotEmpty((Object[])searchStrings)) {
            for (CharSequence next : searchStrings) {
                if (!org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)string, (CharSequence)next)) continue;
                return true;
            }
        }
        return false;
    }
}

