/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.apphub.tool.action;

import com.digiwin.apphub.tool.ToolConstants;
import com.digiwin.apphub.tool.action.PipelineAction;
import com.digiwin.apphub.tool.context.AppMergeContext;
import com.digiwin.apphub.tool.merge.adjust.AdjustProcessor;
import com.digiwin.apphub.tool.utils.LogBlockPrinter;
import com.google.auto.service.AutoService;
import java.util.List;
import javax.inject.Inject;

@AutoService(value={PipelineAction.class})
public class AdjustMergedAppAction
implements PipelineAction {
    private List<AdjustProcessor> processorList;

    @Inject
    public void setProcessor(List<AdjustProcessor> processorList) {
        this.processorList = processorList;
    }

    @Override
    public void execute(AppMergeContext context) throws Exception {
        for (AdjustProcessor processor : this.processorList) {
            int seq = context.incrementSequenceAndGet(ToolConstants.getSequenceKey(this, "mergeProcessor"));
            LogBlockPrinter.printSession(String.format("%02d.Executing processor: %s (%s)", seq, processor.getClass().getName(), processor.getDisplayName()), "Processor finished", context, () -> processor.adjust(context));
        }
    }
}

