/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.apphub.tool.action;

import com.digiwin.apphub.tool.ToolConstants;
import com.digiwin.apphub.tool.action.PipelineAction;
import com.digiwin.apphub.tool.context.AppMergeContext;
import com.digiwin.apphub.tool.setting.dto.ValidationConfig;
import com.digiwin.apphub.tool.utils.LogBlockPrinter;
import com.digiwin.apphub.tool.validation.ValidationProcessor;
import com.google.auto.service.AutoService;
import java.util.List;
import javax.inject.Inject;

@AutoService(value={PipelineAction.class})
public class ValidationAppSourceAction
implements PipelineAction {
    private ValidationConfig config;
    private List<ValidationProcessor> processorList;

    @Inject
    public void setProcessorList(List<ValidationProcessor> validationProcessorList) {
        this.processorList = validationProcessorList;
    }

    @Override
    public void execute(AppMergeContext context) throws Exception {
        this.loadConfig(context);
        for (ValidationProcessor processor : this.processorList) {
            LogBlockPrinter.printGroupStartContent("{}.Executing processor: {} ({})", String.format("%02d", context.incrementSequenceAndGet(ToolConstants.getSequenceKey(this, new String[0]))), processor.getClass().getSimpleName(), processor.getDisplayName());
            processor.validate(context);
            LogBlockPrinter.printGroupScopeContent(null, "Processor finished", new Object[0]);
        }
    }

    private void loadConfig(AppMergeContext context) {
        this.config = context.getSettingProvider().get(ValidationConfig.class, "validation");
    }
}

