/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.apphub.tool.dto;

import com.digiwin.apphub.tool.dto.OPSAppSourceConfig;
import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OPSMergeConfig {
    @SerializedName(value="DOCKER_PROJECT")
    private String dockerProject;
    @SerializedName(value="DOCKER_IMAGE_NAME")
    private String dockerImageName;
    @SerializedName(value="DOCKER_IMAGE_VERSION")
    private String dockerImageVersion;
    @SerializedName(value="PLATFORM_VERSION")
    private String platformVersion;
    @SerializedName(value="APPS")
    private List<OPSAppSourceConfig> apps;

    public String getDockerProject() {
        return this.dockerProject;
    }

    public void setDockerProject(String dockerProject) {
        this.dockerProject = dockerProject;
    }

    public String getDockerImageName() {
        return this.dockerImageName;
    }

    public void setDockerImageName(String dockerImageName) {
        this.dockerImageName = dockerImageName;
    }

    public String getDockerImageVersion() {
        return this.dockerImageVersion;
    }

    public void setDockerImageVersion(String dockerImageVersion) {
        this.dockerImageVersion = dockerImageVersion;
    }

    public String getPlatformVersion() {
        return this.platformVersion;
    }

    public void setPlatformVersion(String platformVersion) {
        this.platformVersion = platformVersion;
    }

    public List<OPSAppSourceConfig> getApps() {
        return this.apps;
    }

    public void setApps(List<OPSAppSourceConfig> apps) {
        this.apps = apps;
    }

    public static OPSMergeConfig load(String configFileName) throws Exception {
        Map<String, String> configMap = OPSMergeConfig.parseMakefile(new File(configFileName));
        OPSMergeConfig config = new OPSMergeConfig();
        config.setDockerProject(configMap.get("DOCKER_PROJECT"));
        config.setDockerImageName(configMap.get("DOCKER_IMAGE_NAME"));
        config.setDockerImageVersion(configMap.get("DOCKER_IMAGE_VERSION"));
        config.setPlatformVersion(configMap.get("PLATFORM_VERSION"));
        String appsJson = configMap.get("APPS");
        if (appsJson != null && appsJson.startsWith("'") && appsJson.endsWith("'")) {
            appsJson = appsJson.substring(1, appsJson.length() - 1);
        }
        List apps = (List)new Gson().fromJson(appsJson, new TypeToken<List<OPSAppSourceConfig>>(){}.getType());
        config.setApps(apps);
        return config;
    }

    private static Map<String, String> parseMakefile(File file) throws IOException {
        HashMap<String, String> result = new HashMap<String, String>();
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            String line;
            while ((line = reader.readLine()) != null) {
                String[] parts;
                if ((line = line.trim()).isEmpty() || line.startsWith("#") || (parts = line.split(":=", 2)).length != 2) continue;
                result.put(parts[0].trim(), parts[1].trim());
            }
        }
        return result;
    }
}

