/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.apphub.tool.merge;

import com.digiwin.apphub.tool.context.AppMergeContext;
import com.digiwin.apphub.tool.merge.AppSourcePathManager;
import com.digiwin.apphub.tool.merge.DAPAppSourcePathManager;
import com.digiwin.apphub.tool.merge.DAPModularAppSourcePathManager;
import com.digiwin.apphub.tool.merge.MergedAppPathManager;
import com.digiwin.apphub.tool.metadata.MergeCategory;

public class MergeCategoryPathManagerInitializer {
    public static void init(AppMergeContext context) {
        MergeCategory category = context.getMergeCategory();
        if (category == null) {
            throw new IllegalArgumentException("Merge category is null!");
        }
        MergedAppPathManager pathManager = context.getMergedAppPathManager();
        switch (category) {
            case DAP_SIMPLIFIED: {
                MergeCategoryPathManagerInitializer.initDapSimplifiedPathManager(pathManager);
                break;
            }
            case DAP_MODULAR: {
                MergeCategoryPathManagerInitializer.initDapModularPathManager(pathManager);
                break;
            }
            case SPRING_BOOT_FAT_JAR: {
                MergeCategoryPathManagerInitializer.initSpringBootFatJarPathManager(pathManager);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported category: " + String.valueOf((Object)category));
            }
        }
    }

    private static AppSourcePathManager initDapSimplifiedPathManager(MergedAppPathManager pathManager) {
        pathManager.addConfigPath("conf", "conf", true);
        pathManager.addConfigPath("lan", "lang");
        pathManager.addLibraryPath("lib", "lib");
        pathManager.addPath(DAPAppSourcePathManager.TYPE_SERVICE_GROUP, "service-group", "lib");
        return pathManager;
    }

    private static AppSourcePathManager initDapModularPathManager(MergedAppPathManager pathManager) {
        pathManager.addConfigPath("platform-conf", "platform/conf");
        pathManager.addConfigPath("platform-lang", "platform/lang");
        pathManager.addLibraryPath("platform-lib", "platform/lib");
        pathManager.addConfigPath("application-conf", "application/conf", true);
        pathManager.addConfigPath("application-lang", "application/lang");
        pathManager.addLibraryPath("application-lib", "application/lib");
        pathManager.addPath(DAPAppSourcePathManager.TYPE_SERVICE_GROUP, DAPModularAppSourcePathManager.USAGE_NAME_APPLICATION_MODULE, "application/module");
        pathManager.addPath(DAPAppSourcePathManager.TYPE_SERVICE_GROUP, DAPModularAppSourcePathManager.USAGE_NAME_PLATFORM_MODULE, "platform/module");
        return pathManager;
    }

    private static AppSourcePathManager initSpringBootFatJarPathManager(MergedAppPathManager pathManager) {
        pathManager.addConfigPath("classes-lib", "BOOT-INF/classes", true);
        pathManager.addLibraryPath("boot-inf-lib", "BOOT-INF/lib");
        return pathManager;
    }
}

