/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.apphub.tool.merge;

import com.digiwin.apphub.tool.merge.AppSourcePathManager;
import com.digiwin.apphub.tool.merge.DAPModularAppSourcePathManager;
import com.digiwin.apphub.tool.merge.DAPSimplifiedAppSourcePathManager;
import com.digiwin.apphub.tool.metadata.AppSource;
import com.digiwin.apphub.tool.metadata.MergeCategory;
import com.digiwin.apphub.tool.metadata.SourceType;
import java.util.HashMap;
import java.util.Map;

public class SourceTypePathManagerFactory {
    public static Map<String, AppSourcePathManager> map = new HashMap<String, AppSourcePathManager>();

    public static AppSourcePathManager get(AppSource appSource, MergeCategory mergeCategory) {
        SourceType sourceType = appSource.getSourceType();
        return switch (sourceType) {
            default -> throw new MatchException(null, null);
            case SourceType.DAP_SIMPLIFIED -> SourceTypePathManagerFactory.getDapSimplifiedPathManager(appSource, mergeCategory);
            case SourceType.DAP_MODULAR -> SourceTypePathManagerFactory.getDapModularPathManager(appSource, mergeCategory);
            case SourceType.SPRING_BOOT_FAT_JAR -> SourceTypePathManagerFactory.getSpringBootFatJarPathManager(appSource, mergeCategory);
            case SourceType.UNKNOWN -> throw new IllegalArgumentException("Unsupported or null sourceType: " + String.valueOf((Object)sourceType));
        };
    }

    private static AppSourcePathManager getDapSimplifiedPathManager(AppSource appSource, MergeCategory mergeCategory) {
        String key = String.format("%s-%s", appSource.getDeploymentName(), appSource.getSourceType().name());
        if (map.containsKey(key)) {
            return map.get(key);
        }
        DAPSimplifiedAppSourcePathManager pathManager = new DAPSimplifiedAppSourcePathManager(appSource);
        map.put(key, pathManager);
        return pathManager;
    }

    private static AppSourcePathManager getDapModularPathManager(AppSource appSource, MergeCategory mergeCategory) {
        String key = String.format("%s-%s", appSource.getDeploymentName(), appSource.getSourceType().name());
        if (map.containsKey(key)) {
            return map.get(key);
        }
        DAPModularAppSourcePathManager pathManager = new DAPModularAppSourcePathManager(appSource);
        map.put(key, pathManager);
        return pathManager;
    }

    private static AppSourcePathManager getSpringBootFatJarPathManager(AppSource appSource, MergeCategory mergeCategory) {
        String key = String.format("%s-%s", appSource.getDeploymentName(), appSource.getSourceType().name());
        if (map.containsKey(key)) {
            return map.get(key);
        }
        AppSourcePathManager pathManager = new AppSourcePathManager(appSource);
        pathManager.addConfigPath("classes-lib", "BOOT-INF/classes", true);
        pathManager.addLibraryPath("boot-inf-lib", "BOOT-INF/lib");
        map.put(key, pathManager);
        return pathManager;
    }
}

