/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.apphub.tool.merge.adjust;

import com.digiwin.apphub.tool.context.AppMergeContext;
import com.digiwin.apphub.tool.context.PrinterContext;
import com.digiwin.apphub.tool.merge.adjust.AdjustProcessor;
import com.digiwin.apphub.tool.utils.LogBlockIcon;
import com.digiwin.apphub.tool.utils.LogBlockPrinter;
import com.digiwin.apphub.tool.utils.PropertiesUtils;
import com.digiwin.apphub.tool.utils.dto.AppSourceTrackingRecord;
import com.google.auto.service.AutoService;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Map;
import java.util.Properties;

@AutoService(value={AdjustProcessor.class})
public class ApplicationPropertiesAdjustProcessor
implements AdjustProcessor {
    @Override
    public String getDisplayName() {
        return "Adjust application.properties";
    }

    @Override
    public void adjust(AppMergeContext context) throws Exception {
        AppSourceTrackingRecord appSourceTrackingRecord = PropertiesUtils.getAppSourceTrackingRecord(context);
        File applicationPropertiesFile = context.getMergedAppPathManager().getApplicationPropertiesFile();
        Properties mergedApplicationProperties = new Properties();
        if (applicationPropertiesFile.exists()) {
            try (InputStream in = Files.newInputStream(applicationPropertiesFile.toPath(), new OpenOption[0]);){
                mergedApplicationProperties.load(in);
            }
        }
        Properties addingProperties = appSourceTrackingRecord.getTraceableProperties();
        LogBlockPrinter.printContent((PrinterContext)context, "file: {}", context.getOutputPath().relativize(applicationPropertiesFile.toPath()));
        LogBlockPrinter.printContent((PrinterContext)context, "adding {} properties...", addingProperties.size());
        addingProperties.entrySet().forEach(item -> LogBlockPrinter.printContent(context.getLevel() + 2, LogBlockIcon.ITEM, "{}={}", item.getKey(), item.getValue()));
        mergedApplicationProperties.putAll((Map<?, ?>)appSourceTrackingRecord.getTraceableProperties());
        try (OutputStream out = Files.newOutputStream(applicationPropertiesFile.toPath(), new OpenOption[0]);){
            mergedApplicationProperties.store(out, "Updated by AdjustMergedAppAction");
        }
    }
}

