/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.apphub.tool.merge.handler;

import com.digiwin.apphub.tool.context.AppMergeContext;
import com.digiwin.apphub.tool.merge.NamedPath;
import com.digiwin.apphub.tool.metadata.AppSource;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public class FileSource {
    AppSource appSource;
    NamedPath sourcePath;
    Path sourceFile;
    public String cachedDisplayName;

    public FileSource() {
    }

    public FileSource(AppSource appSource, NamedPath sourcePath, Path sourceFile) {
        this.appSource = appSource;
        this.sourcePath = sourcePath;
        this.sourceFile = sourceFile;
    }

    public AppSource getAppSource() {
        return this.appSource;
    }

    public NamedPath getSourcePath() {
        return this.sourcePath;
    }

    public Path getSourceFile() {
        return this.sourceFile;
    }

    public InputStream openInputStream() throws IOException {
        return Files.newInputStream(this.sourceFile, new OpenOption[0]);
    }

    public String getSourceFileName() {
        return this.sourceFile.getFileName().toString();
    }

    public String getDisplayName() {
        if (this.cachedDisplayName == null) {
            this.cachedDisplayName = FileSource.getRelativeAppPathDisplayName(this.appSource, this.sourceFile);
        }
        return this.cachedDisplayName;
    }

    public static String getRelativeAppPathDisplayName(AppSource appSource, Path filePath) {
        return FileSource.getRelativeAppPathDisplayName(appSource, filePath, true);
    }

    public static String getRelativeAppPathDisplayName(AppSource appSource, Path filePath, boolean appSourceNameIncluded) {
        Path appPath = appSource.getPath();
        String relative = appPath.relativize(filePath).toString().replace("\\", "/");
        Object displayName = relative;
        if (appSourceNameIncluded) {
            displayName = "[" + appSource.getDeploymentName() + "]/" + (String)displayName;
        }
        return displayName;
    }

    public static String getRelativeOutputPathDisplayName(AppMergeContext context, Path outputFile) {
        String relative;
        Path outputPath = context.getOutputPath();
        String displayName = relative = outputPath.relativize(outputFile).toString().replace("\\", "/");
        return displayName;
    }

    public static String getRelativeOutputPathDisplayName(Path toolOutputPath, Path outputFile) {
        String relative;
        String displayName = relative = toolOutputPath.relativize(outputFile).toString().replace("\\", "/");
        return displayName;
    }
}

