/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.apphub.tool.merge.handler;

import com.digiwin.apphub.tool.context.AppMergeContext;
import com.digiwin.apphub.tool.context.PrinterContext;
import com.digiwin.apphub.tool.inject.InjectSetting;
import com.digiwin.apphub.tool.merge.handler.FileDestination;
import com.digiwin.apphub.tool.merge.handler.FileSource;
import com.digiwin.apphub.tool.merge.handler.MergeableFileHandler;
import com.digiwin.apphub.tool.merge.handler.PropertyGenerateContext;
import com.digiwin.apphub.tool.merge.handler.PropertyLineContext;
import com.digiwin.apphub.tool.merge.handler.PropertyTrackingRecord;
import com.digiwin.apphub.tool.merge.properties.PropertyMergeStrategy;
import com.digiwin.apphub.tool.utils.LogBlockIcon;
import com.digiwin.apphub.tool.utils.LogBlockPrinter;
import com.google.auto.service.AutoService;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.inject.Inject;

@AutoService(value={MergeableFileHandler.class})
public class MergeConfigPropertiesHandler
implements MergeableFileHandler {
    private static final List<Pattern> mergeablePatterns = List.of(Pattern.compile(".*\\.properties"));
    @InjectSetting(key="merge.configPropertiesHandler.exitOnConflict", defaultValue="true")
    private boolean exitOnConflict;
    private List<PropertyMergeStrategy> strategies;

    @Inject
    public void setStrategies(List<PropertyMergeStrategy> strategies) {
        this.strategies = strategies;
    }

    @Override
    public List<Pattern> handlePatterns() {
        return mergeablePatterns;
    }

    @Override
    public boolean canHandle(String fileName) {
        boolean matchPattern = mergeablePatterns.stream().anyMatch(p -> p.matcher(fileName).matches());
        return matchPattern;
    }

    @Override
    public void merge(AppMergeContext appMergeContext, FileDestination mergedDestination, List<FileSource> mergeList) throws Exception {
        LogBlockPrinter.printSession(String.format("generate merged file... %s from %s file(s)", mergedDestination.getOutputRelativeDisplayName(), mergeList.size()), null, appMergeContext, () -> {
            LinkedHashMap<String, String> mergedOutput = new LinkedHashMap<String, String>();
            LinkedHashMap<String, PropertyTrackingRecord> noStrategyProperties = new LinkedHashMap<String, PropertyTrackingRecord>();
            this.parseAllProperties(appMergeContext, mergedDestination, mergeList, noStrategyProperties);
            this.mergeStrategyProperties(appMergeContext, mergedDestination, mergedOutput);
            this.mergeNoStrategyProperties(appMergeContext, noStrategyProperties, mergedOutput);
            this.writeMergedProperties(appMergeContext, mergedDestination, mergeList.size(), mergedOutput);
        });
    }

    private void parseAllProperties(AppMergeContext ctx, FileDestination mergedDestination, List<FileSource> sources, Map<String, PropertyTrackingRecord> noStrategyMap) throws IOException {
        for (FileSource fileSource : sources) {
            Properties props = new Properties();
            try (InputStream in = fileSource.openInputStream();){
                props.load(in);
            }
            PropertyLineContext lineContext = new PropertyLineContext(ctx, fileSource, mergedDestination);
            for (String key : props.stringPropertyNames()) {
                String value = props.getProperty(key);
                lineContext.setKeyValue(key, value);
                PropertyMergeStrategy strategy = this.strategies.stream().filter(s -> s.supports(lineContext)).findFirst().orElse(null);
                if (strategy != null) {
                    strategy.digest(lineContext);
                    continue;
                }
                this.recordNoStrategyProperty(noStrategyMap, key, value, fileSource.getDisplayName());
            }
        }
    }

    private void recordNoStrategyProperty(Map<String, PropertyTrackingRecord> map, String key, String value, String source) {
        map.compute(key, (k, record) -> {
            if (record == null) {
                return new PropertyTrackingRecord(key, source, value);
            }
            if (!value.equals(record.getOriginalValue())) {
                record.addConflict(source, value);
            }
            return record;
        });
    }

    private void mergeStrategyProperties(AppMergeContext ctx, FileDestination mergedDestination, Map<String, String> output) {
        PropertyGenerateContext generateCtx = new PropertyGenerateContext(ctx, mergedDestination.getDestinationFile());
        for (PropertyMergeStrategy strategy : this.strategies) {
            Map<String, String> result = strategy.generate(generateCtx);
            if (result == null) continue;
            result.forEach(output::put);
        }
    }

    private void mergeNoStrategyProperties(AppMergeContext context, Map<String, PropertyTrackingRecord> map, Map<String, String> output) {
        boolean hasConflict = false;
        for (Map.Entry<String, PropertyTrackingRecord> entry : map.entrySet()) {
            String key = entry.getKey();
            PropertyTrackingRecord record = entry.getValue();
            if (record.hasConflict()) {
                hasConflict = true;
                LogBlockPrinter.printContent((PrinterContext)context, LogBlockIcon.WARNING, "Key [{}] has conflicting values:", key);
                LogBlockPrinter.printContent((PrinterContext)context, "  - \"{}\" from {}", record.getOriginalValue(), record.getOriginalFileName());
                for (PropertyTrackingRecord.ConflictEntry conflict : record.getConflictingValues()) {
                    LogBlockPrinter.printContent((PrinterContext)context, "  - \"{}\" conflict in {}", conflict.getValue(), conflict.getSourceFile());
                }
                output.put("Merge-Conflict>>>>>>>>>>" + key, record.getAllValue());
                continue;
            }
            output.put(key, record.getOriginalValue());
        }
        if (hasConflict && this.exitOnConflict) {
            context.exitPipeline("property value conflict detected across source!");
        }
    }

    private void writeMergedProperties(AppMergeContext ctx, FileDestination mergedDestination, int sourceCount, Map<String, String> merged) throws IOException {
        Properties props = new Properties();
        props.putAll(merged);
        try (OutputStream out = mergedDestination.openOutputStream();){
            props.store(out, "Merged by MergeConfigPropertiesHandler");
        }
    }
}

