/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.apphub.tool.merge.handler;

import com.digiwin.apphub.tool.ToolConstants;
import com.digiwin.apphub.tool.context.AppMergeContext;
import com.digiwin.apphub.tool.context.PrinterContext;
import com.digiwin.apphub.tool.merge.handler.FileDestination;
import com.digiwin.apphub.tool.merge.handler.FileSource;
import com.digiwin.apphub.tool.merge.handler.MergeableFileHandler;
import com.digiwin.apphub.tool.merge.handler.PropertyTrackingRecord;
import com.digiwin.apphub.tool.setting.SupportToolSetting;
import com.digiwin.apphub.tool.setting.ToolSettingResolver;
import com.digiwin.apphub.tool.spi.Ordered;
import com.digiwin.apphub.tool.utils.LogBlockIcon;
import com.digiwin.apphub.tool.utils.LogBlockPrinter;
import com.google.auto.service.AutoService;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;

@AutoService(value={MergeableFileHandler.class})
public class MergeI18nPropertiesHandler
implements MergeableFileHandler,
SupportToolSetting,
Ordered {
    public static final String CONFIG_KEY_I18N_BASE_NAME = "filePattern.i18n.baseName";
    private List<Pattern> mergeablePatterns = List.of(Pattern.compile("messages(_[a-z]{2})?\\.properties"));

    @Override
    public List<Pattern> handlePatterns() {
        return this.mergeablePatterns;
    }

    @Override
    public boolean canHandle(String fileName) {
        return this.mergeablePatterns.stream().anyMatch(p -> p.matcher(fileName).matches());
    }

    @Override
    public void merge(AppMergeContext appMergeContext, FileDestination mergedDestination, List<FileSource> mergeList) throws Exception {
        Properties mergedProperties = new Properties();
        LinkedHashMap conflictMap = new LinkedHashMap();
        int sequence = appMergeContext.incrementSequenceAndGet(ToolConstants.getSequenceKey(this, new String[0]));
        LogBlockPrinter.printSession(String.format("%02d.generate merged file [%s]...", sequence, mergedDestination.getOutputRelativeDisplayName()), null, appMergeContext, () -> {
            Properties templateProperties = new Properties();
            Path templatePath = appMergeContext.getMergedAppPathManager().getRuntimeTemplatePath(appMergeContext, mergedDestination);
            if (Files.exists(templatePath, new LinkOption[0])) {
                LogBlockPrinter.printContent((PrinterContext)appMergeContext, LogBlockIcon.INFO, "found template: {}", appMergeContext.getOutputPath().relativize(templatePath));
                try (InputStream in = Files.newInputStream(templatePath, new OpenOption[0]);){
                    templateProperties.load(in);
                }
            }
            for (FileSource source : mergeList) {
                LogBlockPrinter.printContent((PrinterContext)appMergeContext, "  - {}", source.getDisplayName());
                Properties props = new Properties();
                try (InputStream in = source.openInputStream();){
                    props.load(in);
                }
                for (String key : props.stringPropertyNames()) {
                    if (templateProperties.containsKey(key)) continue;
                    String newValue = props.getProperty(key);
                    String oldValue = mergedProperties.getProperty(key);
                    if (oldValue != null && !oldValue.equals(newValue)) {
                        mergedProperties.remove(key);
                        PropertyTrackingRecord record = conflictMap.computeIfAbsent(key, k -> new PropertyTrackingRecord((String)k, source.getDisplayName(), oldValue));
                        record.addConflict(source.getDisplayName(), newValue);
                        continue;
                    }
                    if (conflictMap.containsKey(key)) continue;
                    mergedProperties.setProperty(key, newValue);
                }
            }
            if (!conflictMap.isEmpty()) {
                for (PropertyTrackingRecord record : conflictMap.values()) {
                    mergedProperties.put("Merge-Conflict>>>>>>>>>>" + record.getKey(), record.getAllValue());
                    LogBlockPrinter.printContent((PrinterContext)appMergeContext, LogBlockIcon.WARNING, "Key [{}] has conflicting values:", record.getKey());
                    LogBlockPrinter.printContent((PrinterContext)appMergeContext, "  - \"{}\" from {}", record.getOriginalValue(), record.getOriginalFileName());
                    for (PropertyTrackingRecord.ConflictEntry entry : record.getConflictingValues()) {
                        LogBlockPrinter.printContent((PrinterContext)appMergeContext, "  - \"{}\" conflict in {}", entry.getValue(), entry.getSourceFile());
                    }
                }
            }
            mergedProperties.putAll((Map<?, ?>)templateProperties);
            try (OutputStream out = mergedDestination.openOutputStream();){
                mergedProperties.store(out, "Merged I18n Properties");
            }
        });
    }

    @Override
    public void apply(ToolSettingResolver settingResolver) {
        List baseNameList = settingResolver.getOrDefault(List.class, CONFIG_KEY_I18N_BASE_NAME, Collections.emptyList());
        LogBlockPrinter.printContent(3, LogBlockIcon.ITEM, "custom config[{}] found: {}", CONFIG_KEY_I18N_BASE_NAME, baseNameList);
        this.mergeablePatterns = baseNameList.stream().map(base -> Pattern.compile(Pattern.quote(base) + "(_[a-z]{2}(_[A-Z]{2})?)?\\.properties")).toList();
    }

    @Override
    public int getOrder() {
        return 0;
    }
}

