/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.apphub.tool.merge.handler;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class PropertyTrackingRecord {
    private final String key;
    private String originalFileName;
    private String originalValue;
    private final List<ConflictEntry> conflictingValues = new ArrayList<ConflictEntry>();

    public PropertyTrackingRecord(String key, String originalFileName, String originalValue) {
        this.key = key;
        this.originalFileName = originalFileName;
        this.originalValue = originalValue;
    }

    public void addConflict(String sourceFileName, String value) {
        this.conflictingValues.add(new ConflictEntry(sourceFileName, value));
    }

    public PropertyTrackingRecord(String key) {
        Objects.requireNonNull(key);
        this.key = key;
    }

    public boolean add(String sourceFileName, String value) {
        Objects.requireNonNull(sourceFileName);
        if (this.originalFileName == null) {
            this.originalFileName = sourceFileName;
            this.originalValue = value;
            return true;
        }
        if (this.originalValue != null && !this.originalValue.equals(value)) {
            this.conflictingValues.add(new ConflictEntry(sourceFileName, value));
            return true;
        }
        return false;
    }

    public String getKey() {
        return this.key;
    }

    public String getOriginalFileName() {
        return this.originalFileName;
    }

    public String getOriginalValue() {
        return this.originalValue;
    }

    public String getAllValue() {
        if (!this.hasConflict()) {
            return this.getOriginalValue();
        }
        List values = this.conflictingValues.stream().map(item -> item.getValue()).distinct().map(v -> "[" + v + "]").collect(Collectors.toCollection(ArrayList::new));
        values.add(0, "[" + this.getOriginalValue() + "]");
        return String.join((CharSequence)" - ", values);
    }

    public boolean hasConflict() {
        return !this.conflictingValues.isEmpty();
    }

    public List<ConflictEntry> getConflictingValues() {
        return this.conflictingValues;
    }

    public static class ConflictEntry {
        private final String sourceFile;
        private final String value;

        public ConflictEntry(String sourceFile, String value) {
            this.sourceFile = sourceFile;
            this.value = value;
        }

        public String getSourceFile() {
            return this.sourceFile;
        }

        public String getValue() {
            return this.value;
        }
    }
}

