/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.apphub.tool.merge.properties;

import com.digiwin.apphub.tool.merge.handler.PropertyGenerateContext;
import com.digiwin.apphub.tool.merge.handler.PropertyLineContext;
import com.digiwin.apphub.tool.merge.properties.ContactPropertyStrategy;
import com.digiwin.apphub.tool.merge.properties.MergeStrategySettingProvider;
import com.digiwin.apphub.tool.merge.properties.PropertyMergeStrategy;
import com.digiwin.apphub.tool.setting.SupportToolSetting;
import com.digiwin.apphub.tool.setting.ToolSettingResolver;
import com.google.auto.service.AutoService;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@AutoService(value={PropertyMergeStrategy.class})
public class ArrayUnionPropertyStrategy
implements PropertyMergeStrategy,
SupportToolSetting {
    private static final String PROPERTY_ARRAY_UNION_KEY = "property.arrayUnion.mergeInfo";
    private static final String PROPERTY_STRATEGY_NAME = "arrayUnion";
    private List<Map<String, Object>> strategyList;

    @Override
    public String getName() {
        return PROPERTY_STRATEGY_NAME;
    }

    @Override
    public boolean supports(String key) {
        return this.strategyList.stream().anyMatch(strategyItem -> ((List)strategyItem.get("keys")).contains(key));
    }

    @Override
    public void digest(PropertyLineContext context) {
        ContactPropertyStrategy.MergeInfo mergeInfo = this.putAbsent(context);
        if (Objects.nonNull(mergeInfo)) {
            mergeInfo.add(context.getDestinationFile(), context.getKey(), context.getValue());
        }
    }

    @Override
    public Map<String, String> generate(PropertyGenerateContext context) {
        Map<String, List<String>> properties;
        ContactPropertyStrategy.MergeInfo mergeInfo = this.putAbsent(context);
        if (Objects.nonNull(mergeInfo) && Objects.nonNull(properties = mergeInfo.remove(context.getDestinationFile()))) {
            LinkedHashMap<String, String> resultMap = new LinkedHashMap<String, String>();
            properties.forEach((propKey, propVals) -> {
                for (int i = 0; i < propVals.size(); ++i) {
                    resultMap.put(String.format("%s[%d]", propKey, i), (String)propVals.get(i));
                }
            });
            return resultMap;
        }
        return Map.of();
    }

    @Override
    public void apply(ToolSettingResolver settingResolver) {
        this.strategyList = MergeStrategySettingProvider.get(settingResolver, this);
    }

    private ContactPropertyStrategy.MergeInfo putAbsent(Object context) {
        if (PropertyLineContext.class.isAssignableFrom(context.getClass())) {
            return (ContactPropertyStrategy.MergeInfo)((PropertyLineContext)context).getParentContext().computeIfAbsent(PROPERTY_ARRAY_UNION_KEY, key -> new ContactPropertyStrategy.MergeInfo());
        }
        if (PropertyGenerateContext.class.isAssignableFrom(context.getClass())) {
            return (ContactPropertyStrategy.MergeInfo)((PropertyGenerateContext)context).getParentContext().computeIfAbsent(PROPERTY_ARRAY_UNION_KEY, key -> new ContactPropertyStrategy.MergeInfo());
        }
        return null;
    }
}

