/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.apphub.tool.merge.properties;

import com.digiwin.apphub.tool.merge.handler.PropertyGenerateContext;
import com.digiwin.apphub.tool.merge.handler.PropertyLineContext;
import com.digiwin.apphub.tool.merge.properties.MergeStrategySettingProvider;
import com.digiwin.apphub.tool.merge.properties.PropertyMergeStrategy;
import com.digiwin.apphub.tool.setting.SupportToolSetting;
import com.digiwin.apphub.tool.setting.ToolSettingResolver;
import com.google.auto.service.AutoService;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@AutoService(value={PropertyMergeStrategy.class})
public class ContactPropertyStrategy
implements PropertyMergeStrategy,
SupportToolSetting {
    public static final String NAME = "contact";
    private List<Map<String, Object>> contactStrategies = null;

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean supports(String key) {
        return this.contactStrategies.stream().anyMatch(item -> ((List)item.get("keys")).contains(key));
    }

    private String getDelimiter(String key) {
        Map targetSetting = this.contactStrategies.stream().filter(item -> ((List)item.get("keys")).contains(key)).findFirst().orElse(null);
        if (targetSetting == null) {
            return ",";
        }
        return (String)targetSetting.get("delimiter");
    }

    @Override
    public void digest(PropertyLineContext context) {
        MergeInfo mergeInfo = (MergeInfo)context.getParentContext().computeIfAbsent("property.contact.mergeInfo", key -> new MergeInfo());
        mergeInfo.add(context.getDestinationFile(), context.getKey(), context.getValue());
        context.getDestinationFile();
    }

    @Override
    public Map<String, String> generate(PropertyGenerateContext context) {
        MergeInfo mergeInfo = (MergeInfo)context.getParentContext().computeIfAbsent("property.contact.mergeInfo", key -> new MergeInfo());
        Map<String, List<String>> mergeProperties = mergeInfo.remove(context.getDestinationFile());
        HashMap<String, String> resultMap = new HashMap<String, String>();
        if (mergeProperties != null) {
            for (Map.Entry<String, List<String>> entry : mergeProperties.entrySet()) {
                String key2 = entry.getKey();
                String delimiter = this.getDelimiter(key2);
                List<String> values = entry.getValue();
                String joined = values.stream().flatMap(v -> Arrays.stream(v.split(delimiter))).map(String::trim).filter(s -> !s.isEmpty()).distinct().collect(Collectors.joining(delimiter));
                resultMap.put(key2, joined);
            }
        }
        return resultMap;
    }

    @Override
    public void apply(ToolSettingResolver settingResolver) {
        this.contactStrategies = MergeStrategySettingProvider.get(settingResolver, this);
    }

    public static class MergeInfo {
        private Map<Path, Map<String, List<String>>> processList = new HashMap<Path, Map<String, List<String>>>();

        public void add(Path destinationFile, String key, String value) {
            Map keyValueList = this.processList.computeIfAbsent(destinationFile, processKey -> new HashMap());
            List valueList = keyValueList.computeIfAbsent(key, k -> new ArrayList());
            valueList.add(value);
        }

        public Map<String, List<String>> remove(Path destinationFile) {
            return this.processList.remove(destinationFile);
        }
    }
}

