/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.apphub.tool.merge.properties;

import com.digiwin.apphub.tool.context.AppMergeContext;
import com.digiwin.apphub.tool.merge.handler.PropertyGenerateContext;
import com.digiwin.apphub.tool.merge.handler.PropertyLineContext;
import com.digiwin.apphub.tool.merge.properties.MergeStrategySettingProvider;
import com.digiwin.apphub.tool.merge.properties.PropertyMergeStrategy;
import com.digiwin.apphub.tool.merge.properties.dto.PropertyStrategySetting;
import com.digiwin.apphub.tool.setting.SupportToolSetting;
import com.digiwin.apphub.tool.setting.ToolSettingResolver;
import com.digiwin.apphub.tool.spi.Ordered;
import com.digiwin.apphub.tool.utils.PropertiesUtils;
import com.digiwin.apphub.tool.utils.dto.AppSourceTrackingRecord;
import com.google.auto.service.AutoService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@AutoService(value={PropertyMergeStrategy.class})
public class TraceAppSourcePropertyStrategy
implements PropertyMergeStrategy,
SupportToolSetting,
Ordered {
    public static final String NAME = "traceAppSource";
    private List<PropertyStrategySetting> settings = null;
    private static String KEY_PROPERTY_DEFAULT_VALUE_INFO = "TraceAppSourcePropertyStrategy_tracing_info";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean supports(String key) {
        return this.settings.stream().anyMatch(item -> item.getKeys().contains(key));
    }

    private Map<String, String> getOriginalPropertyDefaultValue(AppMergeContext context) {
        return (Map)context.computeIfAbsent(KEY_PROPERTY_DEFAULT_VALUE_INFO, k -> new HashMap());
    }

    @Override
    public void digest(PropertyLineContext context) {
        AppSourceTrackingRecord trackingRecord = PropertiesUtils.getAppSourceTrackingRecord(context.getParentContext());
        trackingRecord.addProperty(context.getAppSource(), context.getKey(), context.getValue());
        Map<String, String> defaultValueMap = this.getOriginalPropertyDefaultValue(context.getParentContext());
        if (!defaultValueMap.containsKey(context.getKey())) {
            defaultValueMap.put(context.getKey(), context.getValue());
        }
    }

    @Override
    public Map<String, String> generate(PropertyGenerateContext context) {
        Map<String, String> defaultValueMap = this.getOriginalPropertyDefaultValue(context.getParentContext());
        context.getParentContext().remove(KEY_PROPERTY_DEFAULT_VALUE_INFO);
        return defaultValueMap;
    }

    @Override
    public void apply(ToolSettingResolver settingResolver) {
        this.settings = MergeStrategySettingProvider.getSetting(settingResolver, this);
    }

    @Override
    public int getOrder() {
        return 0;
    }
}

