/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.apphub.tool.pipeline;

import com.digiwin.apphub.tool.pipeline.PipelineStep;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class PipelineDescriptor {
    private String profile;
    private List<PipelineStep> steps = new ArrayList<PipelineStep>();
    private Map<String, List<String>> disabledProcessors = new LinkedHashMap<String, List<String>>();

    public List<String> getDisabledProcessors(String key) {
        if (this.disabledProcessors.containsKey(key)) {
            return this.disabledProcessors.get(key);
        }
        return Collections.emptyList();
    }

    public void setDisabledProcessors(Map<String, List<String>> disabledProcessors) {
        this.disabledProcessors = disabledProcessors;
    }

    public String getProfile() {
        return this.profile;
    }

    public void setProfile(String profile) {
        this.profile = profile;
    }

    public List<PipelineStep> getSteps() {
        return this.steps;
    }

    public void setSteps(List<PipelineStep> steps) {
        steps.sort(Comparator.comparingInt(PipelineStep::getOrder));
        this.steps = steps;
    }

    public void addStep(PipelineStep step) {
        this.steps.add(step);
    }

    public boolean isEnabled(String className) {
        return this.steps.stream().anyMatch(step -> step.getName().equals(className) && step.isExecutable());
    }

    public int getOrder(String className) {
        return this.steps.stream().filter(step -> step.getName().equals(className)).map(PipelineStep::getOrder).findFirst().orElse(0);
    }
}

