/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.apphub.tool.setting;

import com.digiwin.apphub.tool.exception.PipelineActionFailedException;
import com.digiwin.apphub.tool.exception.SettingPathNotFoundException;
import com.digiwin.apphub.tool.setting.ToolSettingResolver;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.FileReader;
import java.util.function.Supplier;

public class ToolYamlSettingProvider
implements ToolSettingResolver {
    private final String settingFilePath;
    private final ObjectMapper mapper;
    private final JsonNode root;

    public ToolYamlSettingProvider(String settingFilePath) {
        this.settingFilePath = settingFilePath;
        try (FileReader reader = new FileReader(settingFilePath);){
            this.mapper = new ObjectMapper(new YAMLFactory()).findAndRegisterModules();
            this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            this.root = this.mapper.readTree(reader);
        }
        catch (Exception e) {
            throw new PipelineActionFailedException("Failed to load YAML config: " + settingFilePath, e);
        }
    }

    public String getSettingFilePath() {
        return this.settingFilePath;
    }

    @Override
    public <T> T get(Class<T> configType, String configPath) {
        return this.get(configType, configPath, null);
    }

    @Override
    public <T> T getOrDefault(Class<T> configType, String configPath, T defaultValue) {
        return (T)this.get(configType, configPath, () -> defaultValue);
    }

    @Override
    public <T> T get(Class<T> configType, String configPath, Supplier<T> defaultValueSupplier) {
        try {
            JsonNode current = this.root;
            if (configPath != null && !configPath.isEmpty()) {
                String[] segments;
                String[] stringArray = segments = configPath.split("\\.");
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String segment;
                    String key = segment = stringArray[i];
                    Integer index = null;
                    if (segment.contains("[") && segment.endsWith("]")) {
                        int bracketIndex = segment.indexOf("[");
                        key = segment.substring(0, bracketIndex);
                        index = Integer.parseInt(segment.substring(bracketIndex + 1, segment.length() - 1));
                    }
                    if ((current = current.get(key)) == null) {
                        if (defaultValueSupplier == null) {
                            throw new SettingPathNotFoundException("Path not found: " + configPath);
                        }
                        return defaultValueSupplier.get();
                    }
                    if (index == null) continue;
                    if (!current.isArray()) {
                        throw new IllegalArgumentException("Expected array at: " + key);
                    }
                    current = current.get(index);
                }
            }
            return this.mapper.treeToValue((TreeNode)current, configType);
        }
        catch (SettingPathNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PipelineActionFailedException("get setting object failed: " + configPath, e);
        }
    }
}

