/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.apphub.tool.spi;

import com.digiwin.apphub.tool.inject.InjectSetting;
import com.digiwin.apphub.tool.setting.SupportToolSetting;
import com.digiwin.apphub.tool.setting.ToolSettingResolver;
import com.digiwin.apphub.tool.spi.Ordered;
import com.digiwin.apphub.tool.utils.LogBlockIcon;
import com.digiwin.apphub.tool.utils.LogBlockPrinter;
import jakarta.PostConstruct;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.function.Function;
import javax.inject.Inject;

public class ToolServiceLoader {
    private final List<String> loadedList = new ArrayList<String>();
    private final Map<String, List<String>> disableMap;
    private final ToolSettingResolver settingResolver;
    private final Map<Class<?>, Object> instancePool = new HashMap();

    public ToolServiceLoader(ToolSettingResolver settingResolver) {
        this.settingResolver = settingResolver;
        this.disableMap = settingResolver.get(Map.class, "spi.disableList");
    }

    public <T> List<T> load(Class<T> spiType) {
        return this.load(spiType, null);
    }

    public <T> List<T> load(Class<T> spiType, Function<T, String> extraInfoProvider) {
        String spiTypeName = spiType.getName();
        List typeDisableList = this.disableMap.computeIfAbsent(spiTypeName, key -> Collections.emptyList());
        boolean loaded = this.loadedList.contains(spiTypeName);
        if (!loaded) {
            this.loadedList.add(spiTypeName);
            LogBlockPrinter.printCaption("[Load SPI] - {}", spiTypeName);
        }
        ArrayList<Object> result = new ArrayList<Object>();
        ServiceLoader<T> loader = ServiceLoader.load(spiType);
        for (T impl : loader) {
            Class<?> implClass = impl.getClass();
            String name = implClass.getName();
            if (typeDisableList.contains(name)) {
                if (loaded) continue;
                LogBlockPrinter.printContent(LogBlockIcon.NOTICE, "SPI disabled: {} {}", name, extraInfoProvider == null ? "" : extraInfoProvider.apply(impl));
                continue;
            }
            if (!loaded) {
                Object orderString = "";
                int order = 10000;
                if (impl instanceof Ordered) {
                    order = ((Ordered)impl).getOrder();
                }
                orderString = " | order=" + order;
                LogBlockPrinter.printContent(name + "{}{} ", orderString, extraInfoProvider == null ? "" : extraInfoProvider.apply(impl));
            }
            if (this.instancePool.containsKey(implClass)) {
                result.add(this.instancePool.get(implClass));
                continue;
            }
            this.injectSettingField(impl);
            this.injectSettingMethod(impl);
            if (impl instanceof SupportToolSetting) {
                if (!loaded) {
                    LogBlockPrinter.printContent(2, LogBlockIcon.ITEM, "apply setting...", new Object[0]);
                }
                ((SupportToolSetting)impl).apply(this.settingResolver);
            }
            this.injectSPISetMethod(impl);
            this.invokePostConstruct(impl);
            this.instancePool.put(implClass, impl);
            result.add(impl);
        }
        result.sort((a, b) -> {
            int orderA = a instanceof Ordered ? ((Ordered)a).getOrder() : 10000;
            int orderB = b instanceof Ordered ? ((Ordered)b).getOrder() : 10000;
            return Integer.compare(orderA, orderB);
        });
        return result;
    }

    private void injectSetting(Object spiInstance, Class<?> type, Type genericType, ThrowingBiConsumer setter, InjectSetting injectSetting, String targetName) {
        String key = injectSetting.key();
        String defaultValue = injectSetting.defaultValue();
        try {
            Object value = this.settingResolver.get(type, key, () -> this.resolveDefaultValue(type, genericType, defaultValue));
            setter.accept(spiInstance, value);
            LogBlockPrinter.printContent(2, LogBlockIcon.ITEM, "injected setting [{}] -> {} = {}", key, targetName, value);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to inject setting into " + targetName, e);
        }
    }

    private void injectSettingField(Object spiInstance) {
        Class<?> clazz = spiInstance.getClass();
        for (Field field : clazz.getDeclaredFields()) {
            InjectSetting injectSetting = field.getAnnotation(InjectSetting.class);
            if (injectSetting == null) continue;
            field.setAccessible(true);
            this.injectSetting(spiInstance, field.getType(), field.getGenericType(), field::set, injectSetting, String.format("Field:%s", field.getName()));
        }
    }

    private void injectSettingMethod(Object spiInstance) {
        Class<?> clazz = spiInstance.getClass();
        for (Method method : clazz.getMethods()) {
            InjectSetting injectSetting = method.getAnnotation(InjectSetting.class);
            if (injectSetting == null || method.getParameterCount() != 1) continue;
            Class<?> paramType = method.getParameterTypes()[0];
            Type genericType = method.getGenericParameterTypes()[0];
            this.injectSetting(spiInstance, paramType, genericType, (obj, val) -> method.invoke(obj, val), injectSetting, String.format("Method:%s", method.getName()));
        }
    }

    private Object resolveDefaultValue(Class<?> type, Type genericType, String defaultValue) {
        if ("$empty$".equals(defaultValue) || defaultValue.isBlank()) {
            if (List.class.isAssignableFrom(type)) {
                return Collections.emptyList();
            }
            if (Map.class.isAssignableFrom(type)) {
                return Collections.emptyMap();
            }
            if (type == String.class) {
                return defaultValue;
            }
            if (type == Integer.class || type == Integer.TYPE) {
                return 0;
            }
            if (type == Boolean.class || type == Boolean.TYPE) {
                return false;
            }
            if (type == Long.class || type == Long.TYPE) {
                return 0L;
            }
            try {
                return type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Cannot instantiate type: " + String.valueOf(type), e);
            }
        }
        if ("null".equals(defaultValue)) {
            return null;
        }
        if (List.class.isAssignableFrom(type)) {
            return Arrays.stream(defaultValue.split(",")).map(String::trim).filter(s -> !s.isEmpty()).toList();
        }
        if (Map.class.isAssignableFrom(type)) {
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            for (String entry : defaultValue.split(",")) {
                String[] kv = entry.split("=", 2);
                if (kv.length != 2) continue;
                map.put(kv[0].trim(), kv[1].trim());
            }
            return map;
        }
        return this.convert(defaultValue, type);
    }

    private Object convert(String value, Class<?> targetType) {
        if (targetType == String.class) {
            return value;
        }
        if (targetType == Integer.class || targetType == Integer.TYPE) {
            return Integer.parseInt(value);
        }
        if (targetType == Boolean.class || targetType == Boolean.TYPE) {
            return Boolean.parseBoolean(value);
        }
        if (targetType == Long.class || targetType == Long.TYPE) {
            return Long.parseLong(value);
        }
        throw new IllegalArgumentException("Unsupported defaultValue type: " + String.valueOf(targetType));
    }

    private Object injectSPISetMethod(Object spiInstance) {
        Class<?> clazz = spiInstance.getClass();
        for (Method method : clazz.getMethods()) {
            if (!Modifier.isPublic(method.getModifiers()) || !method.isAnnotationPresent(Inject.class) || method.getParameterCount() != 1) continue;
            Class<?> paramType = method.getParameterTypes()[0];
            Type genericType = method.getGenericParameterTypes()[0];
            try {
                Object injectValue = this.resolveInjectValue(paramType, genericType);
                if (injectValue == null) continue;
                method.invoke(spiInstance, injectValue);
                LogBlockPrinter.printContent(2, LogBlockIcon.ITEM, "injected {} into Method:{}", genericType == null ? paramType.getSimpleName() : genericType, method.getName());
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to inject via " + String.valueOf(method), e);
            }
        }
        return spiInstance;
    }

    private Object resolveInjectValue(Class<?> paramType, Type genericType) {
        if (List.class.isAssignableFrom(paramType) && genericType instanceof ParameterizedType) {
            ParameterizedType inner;
            Type type;
            ParameterizedType pt = (ParameterizedType)genericType;
            Type actualType = pt.getActualTypeArguments()[0];
            Class targetClass = null;
            if (actualType instanceof ParameterizedType && (type = (inner = (ParameterizedType)actualType).getRawType()) instanceof Class) {
                Class raw;
                targetClass = raw = (Class)type;
            } else if (actualType instanceof Class) {
                Class raw;
                targetClass = raw = (Class)actualType;
            }
            if (targetClass != null) {
                return this.load(targetClass, null);
            }
        } else {
            List<?> list = this.load(paramType, null);
            return list.isEmpty() ? null : list.get(0);
        }
        return null;
    }

    private Object invokePostConstruct(Object spiInstance) {
        Class<?> clazz = spiInstance.getClass();
        for (Method method : clazz.getMethods()) {
            if (!Modifier.isPublic(method.getModifiers()) || !method.isAnnotationPresent(PostConstruct.class)) continue;
            if (method.getParameterCount() > 0) {
                LogBlockPrinter.printContent(2, LogBlockIcon.WARNING, "@PostConstruct method {} has parameters, skipping (only no-arg methods are supported)", method.getName());
                continue;
            }
            try {
                method.invoke(spiInstance, new Object[0]);
                LogBlockPrinter.printContent(2, LogBlockIcon.ITEM, "@PostConstruct method {} invoked!", method.getName());
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to invoke @PostConstruct method: " + String.valueOf(method), e);
            }
        }
        return spiInstance;
    }

    @FunctionalInterface
    public static interface ThrowingBiConsumer<T, U> {
        public void accept(T var1, U var2) throws Exception;
    }
}

