/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.apphub.tool.utils;

import com.digiwin.apphub.tool.MergeToolLauncher;
import com.digiwin.apphub.tool.ToolBanner;
import com.digiwin.apphub.tool.context.PrinterContext;
import com.digiwin.apphub.tool.exception.PipelineActionExitException;
import com.digiwin.apphub.tool.pipeline.PipelineStep;
import com.digiwin.apphub.tool.pipeline.PipelineStepMode;
import com.digiwin.apphub.tool.utils.LogBlockIcon;
import com.digiwin.apphub.tool.utils.SessionLogic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogBlockPrinter {
    private static final Logger logger = LoggerFactory.getLogger(LogBlockPrinter.class);

    public static void printBanner() {
        String version = MergeToolLauncher.class.getPackage().getImplementationVersion();
        new ToolBanner(version).print();
    }

    public static void printCaption(String caption, Object ... args) {
        String message = String.format("%s %s", new Object[]{LogBlockIcon.START, caption});
        logger.info(message, args);
    }

    public static void printStepStart(PipelineStep step) {
        String stepNumberString = String.format("%02d", step.getExecutionSeq());
        if (step.getMode() == PipelineStepMode.SKIP) {
            String otherInformation = "";
            if (step.getAction() == null) {
                otherInformation = "| action is not exit!";
            }
            logger.warn("{} [Step {} Skipped] {} {}", new Object[]{LogBlockIcon.SKIP, stepNumberString, step.getName(), otherInformation});
        } else {
            logger.info("{} [Step {} Start] {} | mode={}", new Object[]{LogBlockIcon.START, stepNumberString, step.getName(), step.getMode()});
        }
    }

    public static void printStepExit(PipelineActionExitException exitException) {
        PipelineStep step = exitException.getCurrentStep();
        String stepNumberString = String.format("%02d", step.getExecutionSeq());
        logger.error("{} [Step {} Exit Pipeline] Reason: {}", new Object[]{LogBlockIcon.ACTION_EXIT, stepNumberString, exitException.getMessage()});
    }

    public static void printStepException(PipelineStep step, Exception unexpectedException) {
        String stepNumberString = String.format("%02d", step.getExecutionSeq());
        logger.error("{} [Step {} Failed] {}", new Object[]{LogBlockIcon.ACTION_EXCEPTION, stepNumberString, unexpectedException});
    }

    public static void printStepEnd(PipelineStep step, long executionTime) {
        LogBlockPrinter.printContent(1, LogBlockIcon.CHECK, "Completed - execution time: {} ms", executionTime);
        String stepNumberString = String.format("%02d", step.getExecutionSeq());
        logger.info("{} [Step {} End]", (Object)LogBlockIcon.END, (Object)stepNumberString);
    }

    public static void printContent(String content, Object ... args) {
        LogBlockPrinter.printContent(1, null, content, args);
    }

    public static void printContent(LogBlockIcon icon, String content, Object ... args) {
        LogBlockPrinter.printContent(1, icon, content, args);
    }

    public static void printContent(int indentLevel, LogBlockIcon icon, String content, Object ... args) {
        if (icon == null) {
            icon = LogBlockIcon.ITEM;
        }
        String indent = " ".repeat(indentLevel * 2);
        String message = String.format("%s%s %s", new Object[]{indent, icon, content});
        if (icon == LogBlockIcon.ERROR) {
            logger.error(message, args);
        } else if (icon == LogBlockIcon.WARNING) {
            logger.warn(message, args);
        } else {
            logger.info(message, args);
        }
    }

    public static void printGroupStartContent(String content, Object ... args) {
        int indentLevel = 1;
        String indent = " ".repeat(indentLevel * 2);
        String message = String.format("%s%s %s", new Object[]{indent, LogBlockIcon.GROUP_START, content});
        logger.info(message, args);
    }

    public static void printGroupScopeContent(LogBlockIcon icon, String content, Object ... args) {
        if (icon == null) {
            icon = LogBlockIcon.ITEM;
        }
        int indentLevel = 1;
        String indent = " ".repeat(indentLevel * 2);
        String message = String.format("%s%s%s %s", new Object[]{indent, LogBlockIcon.GROUP_SCOPE, icon, content});
        if (icon == LogBlockIcon.ERROR) {
            logger.error(message, args);
        } else if (icon == LogBlockIcon.WARNING) {
            logger.warn(message, args);
        } else {
            logger.info(message, args);
        }
    }

    public static void printGroupScopeDryRunContent(String content, Object ... args) {
        content = "[Dry Run] " + (String)content;
        LogBlockPrinter.printGroupScopeContent(LogBlockIcon.NOTICE, (String)content, args);
    }

    public static void printGroupScopeDryRunWithNoExitContent(String content, Object ... args) {
        content = "[Dry Run] " + (String)content + " - dry run mode, continue...";
        LogBlockPrinter.printGroupScopeContent(LogBlockIcon.ERROR, (String)content, args);
    }

    public static void printCaption(PrinterContext context, String caption, Object ... args) {
        int level = context.getLevel();
        String indent = "";
        if (level > 0) {
            indent = " ".repeat(level * 2);
        }
        String message = String.format("%s%s %s", new Object[]{indent, LogBlockIcon.PLUS, caption});
        logger.info(message, args);
    }

    public static void printContent(PrinterContext context, String content, Object ... args) {
        LogBlockPrinter.printContent(context, null, content, args);
    }

    public static void printContent(PrinterContext context, LogBlockIcon icon, String content, Object ... args) {
        if (icon == null) {
            icon = LogBlockIcon.ITEM;
        }
        int level = context.getLevel();
        String indent = "";
        if (level > 0) {
            indent = " ".repeat(level * 2);
        }
        String message = String.format("%s  %s %s", new Object[]{indent, icon, content});
        if (icon == LogBlockIcon.WARNING) {
            logger.warn(message, args);
        } else if (icon == LogBlockIcon.ERROR) {
            logger.error(message, args);
        } else {
            logger.info(message, args);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printSession(String caption, String summary, PrinterContext context, SessionLogic logic) throws Exception {
        try {
            context.enterSession();
            LogBlockPrinter.printCaption(context, caption, new Object[0]);
            logic.run();
            if (summary != null) {
                LogBlockPrinter.printContent(context, summary, new Object[0]);
            }
        }
        finally {
            context.exitSession();
        }
    }
}

