/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.apphub.tool.utils;

import com.digiwin.apphub.tool.metadata.SourceType;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;

public final class SourceTypeResolver {
    public static SourceType resolve(File appSourceFolder) {
        if (!appSourceFolder.isDirectory()) {
            throw new IllegalArgumentException("appSourceFolder is not a directory");
        }
        if (SourceTypeResolver.isDAPSimplifiedFolder(appSourceFolder)) {
            return SourceType.DAP_SIMPLIFIED;
        }
        if (SourceTypeResolver.isDAPModularFolder(appSourceFolder)) {
            return SourceType.DAP_MODULAR;
        }
        if (SourceTypeResolver.isSpringBootFatJar(appSourceFolder)) {
            return SourceType.SPRING_BOOT_FAT_JAR;
        }
        return SourceType.UNKNOWN;
    }

    public static boolean isDAPSimplifiedFolder(File appSourceFolder) {
        return SourceTypeResolver.hasSubFolder(appSourceFolder, "conf") && SourceTypeResolver.hasSubFolder(appSourceFolder, "lib") && SourceTypeResolver.hasSubFolder(appSourceFolder, "platform") && SourceTypeResolver.hasSubFolder(appSourceFolder, "platform", "bin");
    }

    public static boolean isDAPModularFolder(File appSourceFolder) {
        return SourceTypeResolver.hasSubFolder(appSourceFolder, "application") && SourceTypeResolver.hasSubFolder(appSourceFolder, "application", "module") && SourceTypeResolver.hasSubFolder(appSourceFolder, "platform") && SourceTypeResolver.hasSubFolder(appSourceFolder, "platform", "module");
    }

    public static boolean isSpringBootFatJar(File appSourceFolder) {
        return SourceTypeResolver.hasSubFolder(appSourceFolder, "BOOT-INF") && SourceTypeResolver.hasSubFolder(appSourceFolder, "META-INF") && SourceTypeResolver.hasManifestWithMainClass(appSourceFolder, "org.springframework.boot.loader.JarLauncher");
    }

    private static boolean hasManifestWithMainClass(File appSourceFolder, String expectedMainClass) {
        boolean bl;
        File manifest = new File(appSourceFolder, "META-INF/MANIFEST.MF");
        if (!manifest.exists()) {
            return false;
        }
        BufferedReader reader = new BufferedReader(new FileReader(manifest));
        try {
            String line;
            boolean hasMain = false;
            boolean hasBoot = false;
            while ((line = reader.readLine()) != null) {
                if (line.trim().equalsIgnoreCase("Main-Class: " + expectedMainClass)) {
                    hasMain = true;
                }
                if (!line.trim().startsWith("Start-Class:")) continue;
                hasBoot = true;
            }
            bl = hasMain && hasBoot;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return false;
            }
        }
        reader.close();
        return bl;
    }

    private static boolean hasSubFolder(File parent, String ... subPath) {
        File current = parent;
        for (String segment : subPath) {
            if ((current = new File(current, segment)).isDirectory()) continue;
            return false;
        }
        return true;
    }
}

