/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.apphub.tool.utils.dto;

import com.digiwin.apphub.tool.metadata.AppSource;
import java.util.Properties;

public class AppSourceTrackingRecord {
    private static final String KEY_PREFIX_MERGE = "dap.merged.";
    private static final String KEY_PREFIX_SOURCE_APP = "dap.merged.apps.";
    private static final String FORMAT_KEY_PREFIX_SOURCE_APP_ID = "dap.merged.apps.%s.";
    private static final String KEY_PART_MODULES = "modules";
    private static final String KEY_PREFIX_DAP_SERVICE_GROUP = "dap.service.group.";
    private static final String FORMAT_KEY_DAP_SERVICE_GROUP_LOOKUP_FALLBACK = "dap.service.group.%s.lookup.fallback";
    public static String KEY_APP_SOURCE_TRACKING_RECORD = "app-source-tracking-record";
    private Properties traceableProperties = new Properties();

    public AppSourceTrackingRecord() {
        this.traceableProperties.setProperty("dap.multiple-app-env", "true");
    }

    public Properties getTraceableProperties() {
        return this.traceableProperties;
    }

    private static String getSourceAppIdPrefix(AppSource appSource) {
        return String.format(FORMAT_KEY_PREFIX_SOURCE_APP_ID, appSource.getAppId());
    }

    private static String getTraceablePropertyKey(AppSource appSource, String propertyKey) {
        return AppSourceTrackingRecord.getSourceAppIdPrefix(appSource) + propertyKey;
    }

    private static String getTraceableModulesKey(AppSource appSource) {
        return AppSourceTrackingRecord.getSourceAppIdPrefix(appSource) + KEY_PART_MODULES;
    }

    public void addProperty(AppSource appSource, String key, String value) {
        this.traceableProperties.setProperty(AppSourceTrackingRecord.getTraceablePropertyKey(appSource, key), value);
    }

    public void addGroup(AppSource appSource, String groupName) {
        String key = AppSourceTrackingRecord.getTraceableModulesKey(appSource);
        if (!this.traceableProperties.containsKey(key)) {
            this.traceableProperties.setProperty(key, groupName);
        } else {
            String value = this.traceableProperties.getProperty(key);
            this.traceableProperties.setProperty(key, String.format("%s,%s", value, groupName));
        }
    }

    public void addRenamedGroup(AppSource appSource, String originalGroupName, String renamedGroupName) {
        String key = String.format(FORMAT_KEY_DAP_SERVICE_GROUP_LOOKUP_FALLBACK, originalGroupName);
        if (!this.traceableProperties.containsKey(key)) {
            this.traceableProperties.setProperty(key, renamedGroupName);
        } else {
            String value = this.traceableProperties.getProperty(key);
            this.traceableProperties.setProperty(key, String.format("%s,%s", value, renamedGroupName));
        }
    }
}

