/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.merge;

import com.digiwin.app.merge.MergeAppContext;
import com.digiwin.app.merge.MergeAppUtils;
import com.digiwin.app.merge.ModularMergeUtil;
import com.digiwin.app.merge.SimplifiedMergeUtil;
import com.digiwin.app.merge.VersionValidUtil;
import com.digiwin.app.merge.enums.DevModeEnum;
import com.digiwin.app.merge.enums.MethodEnum;
import com.digiwin.app.merge.pojo.SourceAppInfo;
import com.digiwin.app.merge.processor.SourceAppProcessor;
import com.digiwin.app.merge.processor.simplified.GroupProcessor;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class MergeApp {
    private static final Logger log = LogManager.getLogger(MergeApp.class);

    MergeApp() {
    }

    public static void main(String[] args) throws Exception {
        if (!MergeApp.validArgs(args)) {
            return;
        }
        String method = args[0];
        DevModeEnum devMode = DevModeEnum.getDevModeEnum(args[1]);
        String workspace = args[2];
        String targetAppRootDir = args[3];
        MergeAppContext context = new MergeAppContext(workspace, targetAppRootDir, MergeAppUtils.getMergedAppPath(workspace));
        context.setDevMode(devMode);
        log.info("--------------------");
        log.info("DAP \u5408\u4f75\u4f48\u7f72\u5de5\u5177");
        log.info("--------------------");
        log.info("\u57f7\u884c\u52d5\u4f5c\uff1a{}\uff0c\u958b\u767c\u6a21\u5f0f\uff1a{}\uff0c\u5de5\u4f5c\u76ee\u9304\uff1a{}\uff0c\u76ee\u6a19\u61c9\u7528\u6839\u76ee\u9304\uff1a{}", (Object)MethodEnum.getMethodEnum(method).getName(), (Object)devMode.getName(), (Object)workspace, (Object)targetAppRootDir);
        log.info("[P.1.\u8b80\u53d6\u5de5\u4f5c\u76ee\u9304]");
        Map<String, SourceAppInfo> sourceApps = SourceAppProcessor.readSourceApps(context);
        context.setAppInfoMap(sourceApps);
        if (sourceApps.size() == 0) {
            log.error(MergeAppUtils.indentMessage(1, "\u627e\u4e0d\u5230\u4efb\u4f55\u7684\u61c9\u7528\u6587\u4ef6\u593e! \u5de5\u4f5c\u5340: " + context.getWorkspace()));
            System.exit(1);
        }
        log.info(MergeAppUtils.indentMessage(1, "\u8b80\u53d6\u5b8c\u6210!"));
        log.info("[P.2.\u5408\u4f75\u61c9\u7528\u6e05\u55ae]");
        int i = 0;
        for (SourceAppInfo sourceAppInfo : sourceApps.values()) {
            log.info(MergeAppUtils.indentMessage(1, String.format("%02d.%s", i++, sourceAppInfo.getUniqueId())));
            if (!sourceAppInfo.hasError()) continue;
            for (String reason : sourceAppInfo.getErrorList()) {
                log.error(MergeAppUtils.indentMessage(2, reason));
            }
        }
        if ("0".equals(method)) {
            VersionValidUtil.validDapVersion(context);
            context.increaseStep();
            VersionValidUtil.valid3rdPartyVersion(context);
            context.increaseStep();
            if (DevModeEnum.SIMPLIFIED == devMode) {
                GroupProcessor.processGroupName(context);
            } else {
                ModularMergeUtil.checkModuleInfo(context);
            }
        } else if ("1".equals(method)) {
            if (DevModeEnum.MODULAR == devMode) {
                MergeAppUtils.cleanMergedApp(context);
                context.increaseStep();
                ModularMergeUtil.checkModuleInfo(context);
                context.increaseStep();
                ModularMergeUtil.mergeModule(context);
                context.increaseStep();
                ModularMergeUtil.mergeLibrary(context);
                context.increaseStep();
                ModularMergeUtil.mergeLanguage(context);
                context.increaseStep();
                ModularMergeUtil.mergeConfig(context);
                context.increaseStep();
            } else {
                MergeAppUtils.cleanMergedApp(context);
                context.increaseStep();
                GroupProcessor.processGroupName(context);
                SimplifiedMergeUtil.mergeLanguage(context);
                context.increaseStep();
                SimplifiedMergeUtil.mergeConfig(context);
                context.increaseStep();
            }
        }
        log.info("--------------------");
        log.info("\u57f7\u884c\u7d50\u675f, \u9000\u51fa\u5de5\u5177");
        log.info("====================");
    }

    private static boolean validArgs(String[] args) {
        int argsLength = args.length;
        if (4 != argsLength) {
            log.error("1,\u5165\u53c3\u6aa2\u67e5\u5931\u6557\uff0c\u9700\u89814\u500b\u5165\u53c3\uff01");
            log.error("\u50b3\u5165\u7684\u53c3\u6578\u70ba: " + Arrays.toString(args));
            return false;
        }
        String workspace = args[2];
        String targetAppRootDir = args[3];
        if (Objects.isNull((Object)MethodEnum.getMethodEnum(args[0]))) {
            log.error("1,\u5165\u53c2\u6aa2\u67e5\u5931\u6557\uff0c\u7b2c\u4e00\u500b\u5165\u53c3\u53ea\u80fd\u662f0\u62161\uff0c0\u8868\u793a\u6aa2\u67e5\u7248\u672c\uff0c1\u8868\u793a\u5408\u4f75");
            return false;
        }
        if (Objects.isNull((Object)DevModeEnum.getDevModeEnum(args[1]))) {
            log.error("1,\u5165\u53c2\u6aa2\u67e5\u5931\u6557\uff0c\u7b2c\u4e8c\u500b\u5165\u53c3\u53ea\u80fd\u662f0\u62161\uff0c0\u8868\u793a\u6a21\u7d44\u5f0f\uff0c1\u8868\u793a\u7c21\u6613\u5f0f");
            return false;
        }
        if (Objects.isNull(workspace) || workspace.isEmpty()) {
            log.error("1,\u5165\u53c2\u6aa2\u67e5\u5931\u6557\uff0c\u7b2c\u4e09\u500b\u5165\u53c3\uff08\u5de5\u4f5c\u76ee\u9304\u7d55\u5c0d\u8def\u5f91\uff09\u4e0d\u80fd\u70ba\u7a7a\uff01");
            return false;
        }
        if (Objects.isNull(targetAppRootDir) || targetAppRootDir.isEmpty()) {
            log.error("1,\u5165\u53c2\u6aa2\u67e5\u5931\u6557\uff0c\u7b2c\u56db\u500b\u5165\u53c3\uff08\u76ee\u6a19\u61c9\u7528\u6839\u76ee\u9304\u7d55\u5c0d\u8def\u5f91\uff09\u4e0d\u80fd\u70ba\u7a7a\uff01");
            return false;
        }
        return true;
    }
}

