/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.merge;

import com.digiwin.app.merge.enums.DevModeEnum;
import com.digiwin.app.merge.pojo.AppModuleNameInfo;
import com.digiwin.app.merge.pojo.SourceAppInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class MergeAppContext {
    private int step = 1;
    private int subStep = 0;
    private int subSubStep = 0;
    private int logIndent = 0;
    private String workspace;
    private String targetAppFolderName;
    private String mergedAppPath;
    private Map<String, SourceAppInfo> appInfoMap;
    private List<AppModuleNameInfo> moduleInfoList = new ArrayList<AppModuleNameInfo>();
    private List<String> invalidModuleNames = new ArrayList<String>();
    private DevModeEnum devMode;

    public int getLogIndent() {
        return this.logIndent;
    }

    public MergeAppContext setLogIndent(int logIndent) {
        this.logIndent = logIndent;
        return this;
    }

    public String getWorkspace() {
        return this.workspace;
    }

    public String getTargetAppFolderName() {
        return this.targetAppFolderName;
    }

    public String getMergedAppPath() {
        return this.mergedAppPath;
    }

    public MergeAppContext(String workspace, String targetAppFolderName, String mergedAppPath) {
        this.workspace = workspace;
        this.targetAppFolderName = targetAppFolderName;
        this.mergedAppPath = mergedAppPath;
    }

    public DevModeEnum getDevMode() {
        return this.devMode;
    }

    public void setDevMode(DevModeEnum devMode) {
        this.devMode = devMode;
    }

    public Map<String, SourceAppInfo> getAppInfoMap() {
        return this.appInfoMap;
    }

    public void setAppInfoMap(Map<String, SourceAppInfo> appInfoMap) {
        this.appInfoMap = appInfoMap;
    }

    public List<AppModuleNameInfo> getModuleInfoList() {
        return this.moduleInfoList;
    }

    public void setModuleInfoList(List<AppModuleNameInfo> moduleInfoList) {
        this.moduleInfoList = moduleInfoList;
    }

    public List<String> getInvalidModuleNames() {
        return this.invalidModuleNames;
    }

    public void setInvalidModuleNames(List<String> invalidModuleNames) {
        this.invalidModuleNames = invalidModuleNames;
    }

    public int getStep() {
        return this.step;
    }

    public int getSubStep() {
        return this.subStep;
    }

    public int getSubSubStep() {
        return this.subSubStep;
    }

    public void increaseStep() {
        ++this.step;
        this.subStep = 0;
        this.subSubStep = 0;
    }

    public void increaseSubStep() {
        ++this.subStep;
        this.subSubStep = 0;
    }

    public void increaseSubSubStep() {
        ++this.subSubStep;
    }

    public SourceAppInfo getTargetAppInfo() {
        return this.appInfoMap.values().stream().filter(a -> a.isTarget()).findFirst().orElse(null);
    }
}

