/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.merge;

import com.digiwin.app.merge.MergeAppContext;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MergeAppUtils {
    private static final Logger log = LogManager.getLogger(MergeAppUtils.class);
    public static final String FOLDER_NAME_MERGED_APP = "dap-merged-app";

    public static String getMergedAppPath(String workspace) {
        return Paths.get(workspace, FOLDER_NAME_MERGED_APP).toFile().getAbsolutePath();
    }

    public static String createStepTitleMessage(MergeAppContext context, String stepType, String stepTitle) {
        context.setLogIndent(0);
        String stepTitleFormat = "[%02d.%s] - %s";
        String title = MergeAppUtils.indentMessage(context.getLogIndent(), String.format(stepTitleFormat, context.getStep(), stepType, stepTitle));
        context.setLogIndent(context.getLogIndent() + 1);
        return title;
    }

    public static String createSubStepTitleMessage(MergeAppContext context, String subStepType, String subStepTitle) {
        context.setLogIndent(1);
        context.increaseSubStep();
        String stepTitleFormat = "[%02d.%s] - %s";
        String title = MergeAppUtils.indentMessage(context.getLogIndent(), String.format(stepTitleFormat, context.getSubStep(), subStepType, subStepTitle));
        context.setLogIndent(context.getLogIndent() + 1);
        return title;
    }

    public static String createSubSubStepTitleMessage(MergeAppContext context, String subSubStepType, String subSubStepTitle) {
        context.setLogIndent(2);
        context.increaseSubSubStep();
        String stepTitleFormat = "[%02d.%s] - %s";
        String title = MergeAppUtils.indentMessage(context.getLogIndent(), String.format(stepTitleFormat, context.getSubSubStep(), subSubStepType, subSubStepTitle));
        context.setLogIndent(context.getLogIndent() + 1);
        return title;
    }

    public static String indentMessage(MergeAppContext context, String message) {
        return MergeAppUtils.indentMessage(context.getLogIndent(), message);
    }

    public static String indentMessage(int count, String message) {
        return String.format("%s%s", MergeAppUtils.indent(count), message);
    }

    public static void cleanMergedApp(MergeAppContext context) throws IOException {
        log.info(MergeAppUtils.createStepTitleMessage(context, "\u6e05\u7406", "\u79fb\u9664\u4e0a\u6b21\u5408\u4f75\u7d50\u679c"));
        File mergedAppFile = new File(context.getMergedAppPath());
        if (mergedAppFile.exists()) {
            log.info(MergeAppUtils.indentMessage(1, "\u522a\u9664\u820a\u7684\u5408\u4f75\u7d50\u679c\u8def\u5f91: " + context.getMergedAppPath()));
            FileUtils.deleteDirectory(mergedAppFile);
            log.info(MergeAppUtils.indentMessage(1, "\u522a\u9664\u6210\u529f"));
        } else {
            log.info(MergeAppUtils.indentMessage(1, "\u4e0d\u9700\u8981\u6e05\u7406, \u8def\u5f91: " + mergedAppFile.getAbsolutePath()));
        }
    }

    public static String indent(int count) {
        if (count <= 0) {
            return "";
        }
        StringBuilder s = new StringBuilder();
        for (int i = 1; i <= count; ++i) {
            if (i == count) {
                s.append(" --");
                continue;
            }
            s.append("   ");
        }
        s.append("> ");
        return s.toString();
    }
}

