/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.merge;

import com.digiwin.app.merge.MergeAppContext;
import com.digiwin.app.merge.MergeAppUtils;
import com.digiwin.app.merge.pojo.AppModuleNameInfo;
import com.digiwin.app.merge.pojo.SourceAppInfo;
import com.digiwin.app.merge.processor.FileProcessor;
import com.digiwin.app.merge.processor.modular.AppPropsProcessor;
import com.digiwin.app.merge.processor.modular.DataPermissionProcessor;
import com.digiwin.app.merge.processor.modular.LangProcessor;
import com.digiwin.app.merge.processor.modular.LibProcessor;
import com.digiwin.app.merge.processor.modular.Log4j2Processor;
import com.digiwin.app.merge.processor.modular.ModuleProcessor;
import com.digiwin.app.merge.processor.modular.ServiceRetryProcessor;
import com.digiwin.app.merge.processor.modular.SpringAppProcessor;
import com.digiwin.app.merge.processor.pojo.SourceAppElement;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Element;

public final class ModularMergeUtil {
    private static final Logger log = LogManager.getLogger(ModularMergeUtil.class);

    private ModularMergeUtil() {
    }

    public static void mergeModule(MergeAppContext context) {
        log.info(MergeAppUtils.createStepTitleMessage(context, "\u5408\u4f75", "\u6a21\u7d44"));
        for (AppModuleNameInfo moduleInfo : context.getModuleInfoList()) {
            String moduleName = moduleInfo.getOriginalModuleName();
            String runtimeModuleName = moduleInfo.getRenamedModuleName() == null ? moduleInfo.getOriginalModuleName() : moduleInfo.getRenamedModuleName();
            String title = runtimeModuleName.equalsIgnoreCase(moduleName) ? String.format("%s \u4f86\u81ea\u65bc (%s)", runtimeModuleName, moduleInfo.getSourceAppInfo().getUniqueId()) : String.format("%s \u4f86\u81ea\u65bc %s (%s)", runtimeModuleName, moduleName, moduleInfo.getSourceAppInfo().getUniqueId());
            log.info(MergeAppUtils.createSubStepTitleMessage(context, "\u6a21\u7d44", title));
            String sourceDir = ModuleProcessor.getPackagedModuleDir(context.getWorkspace(), moduleInfo.getRootDir(), moduleName);
            String targetDir = ModuleProcessor.getTargetModuleDir(context.getWorkspace()) + File.separator + runtimeModuleName;
            ModuleProcessor.moduleCopier(sourceDir, targetDir);
        }
        log.info(MergeAppUtils.indentMessage(1, "\u5408\u4f75\u6a21\u7d44\u5b8c\u6210!"));
    }

    public static void checkModuleInfo(MergeAppContext context) {
        log.info(MergeAppUtils.createStepTitleMessage(context, "\u6aa2\u6e2c", "\u6a21\u7d44\u540d\u7a31"));
        log.info(MergeAppUtils.createSubStepTitleMessage(context, "\u61c9\u7528", context.getTargetAppInfo().getUniqueId()));
        List<AppModuleNameInfo> appModuleInfoList = ModularMergeUtil.createModuleInfoList(context, context.getTargetAppInfo());
        log.info(MergeAppUtils.indentMessage(2, "**\u6a21\u7d44\u6e05\u55ae** " + appModuleInfoList.stream().map(g -> g.getOriginalModuleName()).collect(Collectors.toList())));
        log.error(MergeAppUtils.indentMessage(2, "!!\u4e0d\u7b26\u5408\u898f\u5247\u7684\u6a21\u7d44\u6e05\u55ae!! " + context.getInvalidModuleNames()));
        HashMap<String, List<AppModuleNameInfo>> moduleNameInfoMap = new HashMap<String, List<AppModuleNameInfo>>();
        moduleNameInfoMap.put(context.getTargetAppInfo().getRootDir(), appModuleInfoList);
        context.getModuleInfoList().addAll(appModuleInfoList);
        for (SourceAppInfo appInfo : context.getAppInfoMap().values()) {
            if (appInfo.isTarget()) continue;
            log.info(MergeAppUtils.createSubStepTitleMessage(context, "\u61c9\u7528", appInfo.getUniqueId()));
            appModuleInfoList = ModularMergeUtil.createModuleInfoList(context, appInfo);
            log.info(MergeAppUtils.indentMessage(2, "**\u6a21\u7d44\u6e05\u55ae** " + appModuleInfoList.stream().map(g -> g.getOriginalModuleName()).collect(Collectors.toList())));
            log.error(MergeAppUtils.indentMessage(2, "!!\u4e0d\u7b26\u5408\u898f\u5247\u7684\u6a21\u7d44\u6e05\u55ae!! " + context.getInvalidModuleNames()));
            context.getModuleInfoList().addAll(appModuleInfoList);
            moduleNameInfoMap.put(appInfo.getRootDir(), appModuleInfoList);
        }
        FileProcessor.recordModuleAppMapping(context, moduleNameInfoMap);
        log.info(MergeAppUtils.indentMessage(1, "\u6700\u7d42\u5408\u4f75\u6642\u7522\u751f\u7684\u6a21\u7d44\u6e05\u55ae: " + context.getModuleInfoList().stream().map(g -> g.getRenamedModuleName() == null ? g.getOriginalModuleName() : g.getRenamedModuleName()).collect(Collectors.toCollection(LinkedHashSet::new))));
        log.info(MergeAppUtils.indentMessage(1, "**\u6aa2\u6e2c\u5b8c\u6210**"));
    }

    private static List<AppModuleNameInfo> createModuleInfoList(MergeAppContext context, SourceAppInfo appInfo) {
        Set currentModuleNames = context.getModuleInfoList().stream().map(g -> g.getRenamedModuleName() == null ? g.getOriginalModuleName() : g.getRenamedModuleName()).collect(Collectors.toSet());
        ArrayList<AppModuleNameInfo> moduleInfoList = new ArrayList<AppModuleNameInfo>();
        String moduleDir = ModuleProcessor.getModuleDir(context.getWorkspace(), appInfo.getRootDir());
        List<Path> compiledModulePaths = ModuleProcessor.getModuleTargetPaths(context, moduleDir);
        for (Path compiledModulePath : compiledModulePaths) {
            String moduleName = compiledModulePath.getFileName().toString();
            AppModuleNameInfo info = new AppModuleNameInfo();
            info.setSourceAppInfo(appInfo);
            info.setRootDir(appInfo.getRootDir());
            info.setAppId(appInfo.getAppId());
            info.setIamApToken(appInfo.getIamApToken());
            info.setOriginalModuleName(moduleName);
            moduleInfoList.add(info);
            if (!currentModuleNames.contains(moduleName)) continue;
            String newGroupName = moduleName + "_" + appInfo.getAppId();
            log.warn(MergeAppUtils.indentMessage(3, String.format("\u540d\u7a31: %s \u5df2\u5b58\u5728, \u5408\u4f75\u6642\u5c07\u91cd\u65b0\u547d\u540d\u70ba: %s, \u7de8\u8b6f\u5f8c\u7684\u6a21\u7d44\u8def\u5f91: %s", moduleName, newGroupName, compiledModulePath.toFile().getAbsolutePath())));
            info.setRenamedModuleName(newGroupName);
        }
        return moduleInfoList;
    }

    @Deprecated
    public static void mergeModule_old(MergeAppContext context) {
        log.info(MergeAppUtils.createStepTitleMessage(context, "\u5408\u4f75", "\u8907\u88fd\u7de8\u8b6f\u5f8c\u7684\u6a21\u7d44\u6587\u4ef6\u593e\u5230 application/module..."));
        String workspace = context.getWorkspace();
        String targetAppRootDir = context.getTargetAppFolderName();
        Map<String, SourceAppInfo> sourceApps = context.getAppInfoMap();
        HashMap<String, List<AppModuleNameInfo>> moduleNameInfoMap = new HashMap<String, List<AppModuleNameInfo>>();
        for (SourceAppInfo sourceAppInfo : sourceApps.values()) {
            ArrayList<AppModuleNameInfo> moduleInfoList = new ArrayList<AppModuleNameInfo>();
            String moduleDir = ModuleProcessor.getModuleDir(workspace, sourceAppInfo.getRootDir());
            List<String> moduleNames = ModuleProcessor.getModuleNames(moduleDir);
            for (String moduleName : moduleNames) {
                AppModuleNameInfo info = new AppModuleNameInfo();
                info.setSourceAppInfo(sourceAppInfo);
                info.setRootDir(sourceAppInfo.getRootDir());
                info.setAppId(sourceApps.get(sourceAppInfo.getRootDir()).getAppId());
                info.setIamApToken(sourceApps.get(sourceAppInfo.getRootDir()).getIamApToken());
                info.setOriginalModuleName(moduleName);
                moduleInfoList.add(info);
            }
            moduleNameInfoMap.put(sourceAppInfo.getRootDir(), moduleInfoList);
        }
        List targetModuleInfoList = (List)moduleNameInfoMap.get(targetAppRootDir);
        for (AppModuleNameInfo info : targetModuleInfoList) {
            String sourceAppRootDir = info.getRootDir();
            String moduleName = info.getOriginalModuleName();
            String sourceDir = ModuleProcessor.getPackagedModuleDir(workspace, sourceAppRootDir, moduleName);
            String targetDir = ModuleProcessor.getTargetModuleDir(workspace) + File.separator + moduleName;
            ModuleProcessor.moduleCopier(sourceDir, targetDir);
        }
        for (SourceAppInfo sourceAppInfo : sourceApps.values()) {
            if (sourceAppInfo.isTarget()) continue;
            log.info(MergeAppUtils.indentMessage(1, "\u61c9\u7528: " + sourceAppInfo.getUniqueId()));
            List moduleInfoList = (List)moduleNameInfoMap.get(sourceAppInfo.getRootDir());
            for (AppModuleNameInfo info : moduleInfoList) {
                String appId = info.getAppId();
                String moduleName = info.getOriginalModuleName();
                String sourceDir = ModuleProcessor.getPackagedModuleDir(workspace, sourceAppInfo.getRootDir(), moduleName);
                String targetDir = ModuleProcessor.getTargetModuleDir(workspace) + File.separator + moduleName;
                if (Files.exists(Paths.get(targetDir, new String[0]), new LinkOption[0])) {
                    String renamedModuleName = moduleName + "_" + appId;
                    info.setRenamedModuleName(renamedModuleName);
                    targetDir = ModuleProcessor.getTargetModuleDir(workspace) + File.separator + renamedModuleName;
                    log.warn(MergeAppUtils.indentMessage(2, "\u6a21\u7ec4\u540d\u51b2\u7a81: \u91cd\u547d\u540d\u4f86\u6e90\u61c9\u7528{}\u4e2d\u7684\u6a21\u7d44{}\u70ba{}\u3002"), (Object)appId, (Object)moduleName, (Object)renamedModuleName);
                }
                ModuleProcessor.moduleCopier(sourceDir, targetDir);
            }
        }
        FileProcessor.recordModuleAppMapping(context, moduleNameInfoMap);
        log.info(MergeAppUtils.indentMessage(1, "[\u5408\u4f75\u6a21\u7d44] - \u8655\u7406\u5b8c\u6210."));
    }

    public static void mergeLibrary(MergeAppContext context) {
        List sourceDirs;
        log.info(MergeAppUtils.createStepTitleMessage(context, "\u5408\u4f75", "\u7b2c\u4e09\u65b9\u985e\u5eab"));
        String workspace = context.getWorkspace();
        String targetAppRootDir = context.getTargetAppFolderName();
        Map<String, SourceAppInfo> sourceApps = context.getAppInfoMap();
        String targetDir = LibProcessor.getTargetLibDir(workspace);
        log.info(MergeAppUtils.indentMessage(1, "\u5408\u4f75\u7d50\u679c\u8def\u5f91: " + targetDir));
        LinkedHashMap<SourceAppInfo, List> appSourceDirMap = new LinkedHashMap<SourceAppInfo, List>();
        for (SourceAppInfo sourceAppInfo : sourceApps.values()) {
            String rootDir = sourceAppInfo.getRootDir();
            if (sourceAppInfo.isTarget()) continue;
            sourceDirs = appSourceDirMap.computeIfAbsent(sourceAppInfo, key -> new ArrayList());
            sourceDirs.add(LibProcessor.getLibJarDir(workspace, rootDir));
            sourceDirs.add(LibProcessor.get3rdPartyJarDir(workspace, rootDir));
        }
        sourceDirs = appSourceDirMap.computeIfAbsent(context.getTargetAppInfo(), key -> new ArrayList());
        sourceDirs.add(LibProcessor.getLibJarDir(workspace, context.getTargetAppInfo().getRootDir()));
        sourceDirs.add(LibProcessor.get3rdPartyJarDir(workspace, context.getTargetAppInfo().getRootDir()));
        for (Map.Entry entry : appSourceDirMap.entrySet()) {
            log.info(MergeAppUtils.createSubStepTitleMessage(context, "\u61c9\u7528", ((SourceAppInfo)entry.getKey()).getUniqueId()));
            for (String copyFromPath : (List)entry.getValue()) {
                if (Files.exists(Paths.get(copyFromPath, new String[0]), new LinkOption[0])) {
                    log.info(MergeAppUtils.indentMessage(2, "\u8907\u88fd\u8def\u5f91: " + copyFromPath));
                    FileProcessor.jarCopier(copyFromPath, targetDir);
                    continue;
                }
                log.info(MergeAppUtils.indentMessage(2, "\u4e0d\u8907\u88fd\u4e0d\u5b58\u5728\u7684\u8def\u5f91: " + copyFromPath));
            }
        }
        log.info(MergeAppUtils.indentMessage(1, "\u5408\u4f75\u7b2c\u4e09\u65b9\u985e\u5eab\u5b8c\u6210!"));
    }

    public static void mergeLanguage(MergeAppContext context) {
        log.info(MergeAppUtils.createStepTitleMessage(context, "\u5408\u4f75", "\u61c9\u7528\u5c64\u591a\u8a9e\u8a00\u6587\u4ef6"));
        String workspace = context.getWorkspace();
        String targetAppRootDir = context.getTargetAppFolderName();
        Map<String, SourceAppInfo> sourceApps = context.getAppInfoMap();
        String targetDir = LangProcessor.getTargetLanguageDir(workspace);
        log.info(MergeAppUtils.indentMessage(1, "\u5408\u4f75\u7d50\u679c\u8def\u5f91: " + targetDir));
        for (SourceAppInfo sourceApp : sourceApps.values()) {
            String rootDir = sourceApp.getRootDir();
            if (targetAppRootDir.equals(rootDir)) continue;
            String sourceDir = LangProcessor.getLanguageDir(workspace, rootDir);
            log.info(MergeAppUtils.createSubStepTitleMessage(context, "\u61c9\u7528", sourceApp.getUniqueId()));
            FileProcessor.mergeMessages(context, sourceDir, targetDir);
        }
        String sourceDir = LangProcessor.getLanguageDir(workspace, targetAppRootDir);
        log.info(MergeAppUtils.createSubStepTitleMessage(context, "\u61c9\u7528", context.getTargetAppInfo().getUniqueId()));
        FileProcessor.mergeMessages(context, sourceDir, targetDir);
        log.info(MergeAppUtils.indentMessage(1, "\u5408\u4f75\u5b8c\u6210!"));
    }

    public static void mergeConfig(MergeAppContext context) {
        log.info(MergeAppUtils.createStepTitleMessage(context, "\u5408\u4f75", "\u61c9\u7528\u5c64\u914d\u7f6e"));
        String targetAppRootDir = context.getTargetAppFolderName();
        log.info(MergeAppUtils.indentMessage(context.getLogIndent(), "\u5408\u4f75\u7d50\u679c\u8def\u5f91: " + FileProcessor.getTargetApplicationConfDir(context.getWorkspace())));
        Map<String, SourceAppInfo> sourceApps = context.getAppInfoMap();
        ModularMergeUtil.mergeApplication(context, sourceApps, targetAppRootDir);
        ModularMergeUtil.mergeLog4j2(context);
        ModularMergeUtil.mergeSpringApplication(context, sourceApps, targetAppRootDir);
        ModularMergeUtil.mergeServiceRetryConfig(context, sourceApps, targetAppRootDir);
        DataPermissionProcessor.merge(context);
        log.info(MergeAppUtils.indentMessage(1, "\u5408\u4f75\u61c9\u7528\u5c64\u914d\u7f6e\u5b8c\u6210!"));
    }

    private static void mergeApplication(MergeAppContext context, Map<String, SourceAppInfo> sourceApps, String targetAppRootDir) {
        String workspace = context.getWorkspace();
        log.info(MergeAppUtils.createSubStepTitleMessage(context, "\u914d\u7f6e", "application.properties"));
        String targetFile = AppPropsProcessor.getTargetApplicationFile(workspace);
        for (SourceAppInfo sourceApp : sourceApps.values()) {
            String rootDir = sourceApp.getRootDir();
            if (targetAppRootDir.equals(rootDir)) continue;
            String sourceFile = AppPropsProcessor.getApplicationFile(workspace, rootDir);
            AppPropsProcessor.merge(sourceFile, targetFile);
        }
        String sourceFile = AppPropsProcessor.getApplicationFile(workspace, targetAppRootDir);
        AppPropsProcessor.merge(sourceFile, targetFile);
        AppPropsProcessor.finishedMerge(context);
        log.info(MergeAppUtils.indentMessage(2, "\u5408\u4f75\u5b8c\u6210!"));
    }

    private static void mergeLog4j2(MergeAppContext context) {
        String workspace = context.getWorkspace();
        log.info(MergeAppUtils.createSubStepTitleMessage(context, "\u65e5\u8a8c", "log4j2.xml"));
        String targetFile = Log4j2Processor.getTargetLog4j2File(workspace);
        ArrayList<SourceAppElement> loggers = new ArrayList<SourceAppElement>();
        for (SourceAppInfo sourceApp : context.getAppInfoMap().values()) {
            String sourceFile;
            SourceAppElement sourceAppElement;
            if (sourceApp.isTarget() || (sourceAppElement = Log4j2Processor.readLoggers(context, sourceApp, sourceFile = Log4j2Processor.getLog4j2File(workspace, sourceApp.getRootDir()))) == null) continue;
            loggers.add(sourceAppElement);
        }
        String sourceFile = Log4j2Processor.getLog4j2File(workspace, context.getTargetAppFolderName());
        Log4j2Processor.merge(context, sourceFile, targetFile, loggers);
        log.info(MergeAppUtils.indentMessage(2, "\u5408\u4f75\u5b8c\u6210!"));
    }

    private static void mergeSpringApplication(MergeAppContext context, Map<String, SourceAppInfo> sourceApps, String targetAppRootDir) {
        String workspace = context.getWorkspace();
        log.info(MergeAppUtils.createSubStepTitleMessage(context, "Spring Bean", "spring-application.xml"));
        String targetFile = SpringAppProcessor.getTargetSpringApplicationFile(workspace);
        ArrayList<Element> beanList = new ArrayList<Element>();
        ArrayList<Element> componentScanList = new ArrayList<Element>();
        for (SourceAppInfo sourceApp : sourceApps.values()) {
            String rootDir = sourceApp.getRootDir();
            if (targetAppRootDir.equals(rootDir)) continue;
            log.info(MergeAppUtils.createSubSubStepTitleMessage(context, "\u61c9\u7528", sourceApp.getUniqueId()));
            String sourceFile = SpringAppProcessor.getSpringApplicationFile(workspace, rootDir);
            SpringAppProcessor.readBeanAndComponentScan(context, sourceFile, beanList, componentScanList);
        }
        String sourceFile = SpringAppProcessor.getSpringApplicationFile(workspace, targetAppRootDir);
        SpringAppProcessor.merge(context, sourceFile, targetFile, beanList, componentScanList);
        log.info(MergeAppUtils.indentMessage(2, "\u5408\u4f75\u5b8c\u6210!"));
    }

    private static void mergeServiceRetryConfig(MergeAppContext context, Map<String, SourceAppInfo> sourceApps, String targetAppRootDir) {
        String workspace = context.getWorkspace();
        log.info(MergeAppUtils.createSubStepTitleMessage(context, "HTTP \u91cd\u8a66\u898f\u5247", "service-retry-config.json"));
        String targetFile = ServiceRetryProcessor.getTargetServiceRetryConfigFile(workspace);
        String sourceFile = ServiceRetryProcessor.getServiceRetryConfigFile(workspace, targetAppRootDir);
        log.info(MergeAppUtils.createSubSubStepTitleMessage(context, "\u61c9\u7528", context.getTargetAppInfo().getUniqueId()));
        ServiceRetryProcessor.merge(context, sourceFile, targetFile);
        for (SourceAppInfo sourceApp : sourceApps.values()) {
            String rootDir = sourceApp.getRootDir();
            if (sourceApp.isTarget()) continue;
            log.info(MergeAppUtils.createSubSubStepTitleMessage(context, "\u61c9\u7528", sourceApp.getUniqueId()));
            sourceFile = ServiceRetryProcessor.getServiceRetryConfigFile(workspace, rootDir);
            ServiceRetryProcessor.merge(context, sourceFile, targetFile);
        }
        log.info(MergeAppUtils.indentMessage(2, "\u5408\u4f75\u5b8c\u6210"));
    }
}

