/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.merge;

import com.digiwin.app.merge.MergeAppContext;
import com.digiwin.app.merge.exception.MergeAppException;
import com.digiwin.app.merge.pojo.SourceSimplifiedAppInfo;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;

public class SimplifiedDAPUtils {
    public static final String FILE_NAME_POM_XML = "pom.xml";
    public static final String FOLDER_NAME_DEVELOP = "develop";
    public static final String FOLDER_NAME_DEVELOP_CONF = "develop" + File.separator + "conf";
    public static final String FOLDER_NAME_COMPILE_OUTPUT_PATH = "develop" + File.separator + "target";
    public static final String FOLDER_NAME_THIRD_PARTY_LIBRARY = "DWThirdPartyLibrary";
    static final String DEFAULT_FILE_PATH = "develop/src/main/resources/META-INF";

    public static Path getBackendPath(MergeAppContext context, String appSourceCodeFolderName) throws MergeAppException {
        String backendFolderNameSuffix = "_backend";
        File file = Paths.get(context.getWorkspace(), appSourceCodeFolderName).toFile();
        if (!file.exists() && !file.isDirectory()) {
            throw new MergeAppException("\u61c9\u7528\u6e90\u78bc\u6587\u4ef6\u540d\u5c0d\u61c9\u7684\u6587\u4ef6\u593e\u4e26\u4e0d\u5b58\u5728, \u6216\u8005\u4e0d\u662f\u4e00\u500b\u6587\u4ef6\u593e!");
        }
        File[] backendFolders = file.listFiles((dir, name) -> {
            File currentFile = new File(dir, name);
            return currentFile.isDirectory() && name.toLowerCase().endsWith(backendFolderNameSuffix);
        });
        if (backendFolders.length == 1) {
            return backendFolders[0].toPath();
        }
        if (backendFolders.length == 0) {
            throw new MergeAppException(String.format("\u6c92\u6709\u4efb\u4f55\u5f8c\u7db4\u70ba %s \u7684\u6587\u4ef6\u593e\u5728\u61c9\u7528(%s)\u6e90\u78bc\u6587\u4ef6\u593e\u4e2d!", backendFolderNameSuffix, appSourceCodeFolderName));
        }
        throw new MergeAppException(String.format("\u5b58\u5728\u4e00\u500b\u4ee5\u4e0a\u5f8c\u7db4\u540d\u70ba %s \u7684\u6587\u4ef6\u593e:%s \u5728\u61c9\u7528:%s \u6e90\u78bc\u6587\u4ef6\u593e\u4e2d!", backendFolderNameSuffix, Arrays.stream(backendFolders).map(f -> f.getName()), appSourceCodeFolderName));
    }

    public static Path getRootPOMXmlPath(SourceSimplifiedAppInfo sourceAppInfo) throws MergeAppException {
        SimplifiedDAPUtils.checkIfBackendExists(sourceAppInfo);
        Path pomXmlPath = Paths.get(sourceAppInfo.getBackendPath().toFile().getAbsolutePath(), FILE_NAME_POM_XML);
        if (Files.exists(pomXmlPath, new LinkOption[0])) {
            return pomXmlPath;
        }
        throw new MergeAppException(String.format("\u6839 pom.xml \u4e0d\u5b58\u5728! \u8def\u5f91:%s", pomXmlPath.toAbsolutePath()));
    }

    public static Path getApplicationPropertiesPath(MergeAppContext context, SourceSimplifiedAppInfo sourceAppInfo) {
        SimplifiedDAPUtils.checkIfBackendExists(sourceAppInfo);
        Path applicationPropertiesPath = Paths.get(sourceAppInfo.getBackendPath().toFile().getAbsolutePath(), FOLDER_NAME_DEVELOP_CONF, "application.properties");
        return applicationPropertiesPath;
    }

    public static String getMergedAppConfDir(MergeAppContext context) {
        return context.getMergedAppPath() + File.separator + "conf";
    }

    public static Path getThirdPartyLibraryPOMXmlPath(SourceSimplifiedAppInfo sourceAppInfo) throws MergeAppException {
        SimplifiedDAPUtils.checkIfBackendExists(sourceAppInfo);
        Path pomXmlPath = Paths.get(sourceAppInfo.getBackendPath().toFile().getAbsolutePath(), FOLDER_NAME_THIRD_PARTY_LIBRARY, FILE_NAME_POM_XML);
        if (Files.exists(pomXmlPath, new LinkOption[0])) {
            return pomXmlPath;
        }
        throw new MergeAppException(String.format("\u7b2c\u4e09\u65b9\u985e\u5eab pom.xml \u4e0d\u5b58\u5728! \u8def\u5f91:%s", pomXmlPath.toAbsolutePath()));
    }

    public static Path getDevelopConfApplicationPropertiesPath(SourceSimplifiedAppInfo sourceAppInfo) throws MergeAppException {
        SimplifiedDAPUtils.checkIfBackendExists(sourceAppInfo);
        Path pomXmlPath = Paths.get(sourceAppInfo.getBackendPath().toFile().getAbsolutePath(), FOLDER_NAME_DEVELOP_CONF, "application.properties");
        if (Files.exists(pomXmlPath, new LinkOption[0])) {
            return pomXmlPath;
        }
        throw new MergeAppException(String.format("application.properties \u4e0d\u5b58\u5728! \u8def\u5f91:%s", pomXmlPath.toAbsolutePath()));
    }

    public static Path getCompileOutputBackendPath(SourceSimplifiedAppInfo sourceAppInfo) throws MergeAppException {
        SimplifiedDAPUtils.checkIfBackendExists(sourceAppInfo);
        File backendFile = sourceAppInfo.getBackendPath().toFile();
        Path outputBackendPath = Paths.get(backendFile.getAbsolutePath(), FOLDER_NAME_COMPILE_OUTPUT_PATH, backendFile.getName());
        if (Files.exists(outputBackendPath, new LinkOption[0])) {
            return outputBackendPath;
        }
        throw new MergeAppException(String.format("\u7de8\u8b6f\u8f38\u51fa\u8def\u5f91\u7684 backend \u6587\u4ef6\u593e\u4e0d\u5b58\u5728! \u8def\u5f91:%s", outputBackendPath.toAbsolutePath()));
    }

    private static boolean checkIfBackendExists(SourceSimplifiedAppInfo sourceAppInfo) throws MergeAppException {
        if (sourceAppInfo.isBackendNotFound()) {
            throw new MergeAppException(String.format("\u6c92\u6709 Backend \u6587\u4ef6\u593e", sourceAppInfo.getUniqueId()));
        }
        return true;
    }
}

