/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.merge;

import com.digiwin.app.merge.MergeAppContext;
import com.digiwin.app.merge.MergeAppUtils;
import com.digiwin.app.merge.SimplifiedDAPUtils;
import com.digiwin.app.merge.enums.SimplifiedDAPConfigLayer;
import com.digiwin.app.merge.pojo.SourceAppInfo;
import com.digiwin.app.merge.pojo.SourceSimplifiedAppInfo;
import com.digiwin.app.merge.processor.FileProcessor;
import com.digiwin.app.merge.processor.pojo.SourceAppElement;
import com.digiwin.app.merge.processor.simplified.LibProcessor;
import com.digiwin.app.merge.processor.simplified.SimplifiedDAPAppPropsProcessor;
import com.digiwin.app.merge.processor.simplified.SimplifiedDataPermissionProcessor;
import com.digiwin.app.merge.processor.simplified.SimplifiedLangProcessor;
import com.digiwin.app.merge.processor.simplified.SimplifiedLog4j2Processor;
import com.digiwin.app.merge.processor.simplified.SimplifiedPlatformProcessor;
import com.digiwin.app.merge.processor.simplified.SimplifiedServiceRetryProcessor;
import com.digiwin.app.merge.processor.simplified.SimplifiedSpringAppProcessor;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Element;

public final class SimplifiedMergeUtil {
    private static final Logger log = LogManager.getLogger(SimplifiedMergeUtil.class);

    private SimplifiedMergeUtil() {
    }

    public static void mergePlatform(MergeAppContext context) {
        log.info(MergeAppUtils.createStepTitleMessage(context, "\u5408\u4f75", "\u8907\u88fd\u5e73\u53f0\u5c64"));
        String platformDir = SimplifiedPlatformProcessor.getPlatformDir((SourceSimplifiedAppInfo)context.getTargetAppInfo());
        String targetPlatformDir = SimplifiedPlatformProcessor.getMergedAppPlatformPath(context);
        log.info(MergeAppUtils.indentMessage(1, "\u5408\u4f75\u7d50\u679c\u8def\u5f91: " + targetPlatformDir));
        log.info(MergeAppUtils.indentMessage(context, "\u8907\u88fd\u8def\u5f91: " + Paths.get(platformDir, new String[0])));
        SimplifiedPlatformProcessor.copy(Paths.get(platformDir, new String[0]), Paths.get(targetPlatformDir, new String[0]));
        log.info(MergeAppUtils.indentMessage(context, "\u5408\u4f75\u5b8c\u6210!"));
    }

    public static void mergeLibrary(MergeAppContext context) {
        log.info(MergeAppUtils.createStepTitleMessage(context, "\u5408\u4f75", "\u8907\u88fd\u61c9\u7528\u5c64\u985e\u5eab"));
        String workspace = context.getWorkspace();
        Map<String, SourceAppInfo> sourceApps = context.getAppInfoMap();
        String targetLibDir = LibProcessor.getTargetLibDir(workspace);
        log.info(MergeAppUtils.indentMessage(1, "\u5408\u4f75\u7d50\u679c\u8def\u5f91: " + targetLibDir));
        for (SourceAppInfo sourceApp : sourceApps.values()) {
            if (sourceApp.isTarget()) continue;
            String libDir = LibProcessor.getSourceLibDir((SourceSimplifiedAppInfo)sourceApp);
            log.info(MergeAppUtils.createSubStepTitleMessage(context, "\u61c9\u7528", sourceApp.getUniqueId()));
            log.info(MergeAppUtils.indentMessage(2, "\u8907\u88fd\u8def\u5f91: " + libDir));
            FileProcessor.jarCopier(libDir, targetLibDir);
        }
        String libDir = LibProcessor.getSourceLibDir((SourceSimplifiedAppInfo)context.getTargetAppInfo());
        log.info(MergeAppUtils.createSubStepTitleMessage(context, "\u61c9\u7528", context.getTargetAppInfo().getUniqueId()));
        log.info(MergeAppUtils.indentMessage(2, "\u8907\u88fd\u8def\u5f91: " + libDir));
        FileProcessor.jarCopier(libDir, targetLibDir);
        log.info("\u5408\u4f75\u5b8c\u6210!");
    }

    public static void mergeLanguage(MergeAppContext context) {
        log.info(MergeAppUtils.createStepTitleMessage(context, "\u5408\u4f75", "\u61c9\u7528\u5c64\u591a\u8a9e\u8a00\u6587\u4ef6"));
        String targetDir = SimplifiedLangProcessor.getTargetLanguageDir(context);
        Map<String, SourceAppInfo> sourceApps = context.getAppInfoMap();
        log.info(MergeAppUtils.indentMessage(1, "\u5408\u4f75\u7d50\u679c\u8def\u5f91: " + targetDir));
        for (SourceAppInfo sourceApp : sourceApps.values()) {
            if (sourceApp.isTarget()) continue;
            log.info(MergeAppUtils.createSubStepTitleMessage(context, "\u61c9\u7528", sourceApp.getUniqueId()));
            String sourceDir = SimplifiedLangProcessor.getLanguageDir((SourceSimplifiedAppInfo)sourceApp);
            FileProcessor.mergeMessages(context, sourceDir, targetDir);
        }
        log.info(MergeAppUtils.createSubStepTitleMessage(context, "\u61c9\u7528", context.getTargetAppInfo().getUniqueId()));
        String sourceDir = SimplifiedLangProcessor.getLanguageDir((SourceSimplifiedAppInfo)context.getTargetAppInfo());
        FileProcessor.mergeMessages(context, sourceDir, targetDir);
        log.info(MergeAppUtils.indentMessage(1, "\u5408\u4f75\u5b8c\u6210!"));
    }

    public static void mergeConfig(MergeAppContext context) {
        log.info(MergeAppUtils.createStepTitleMessage(context, "\u5408\u4f75", "\u529f\u80fd\u914d\u7f6e"));
        String targetAppRootDir = context.getTargetAppFolderName();
        log.info(MergeAppUtils.indentMessage(context.getLogIndent(), "\u5408\u4f75\u7d50\u679c\u8def\u5f91: " + SimplifiedDAPUtils.getMergedAppConfDir(context)));
        Map<String, SourceAppInfo> sourceApps = context.getAppInfoMap();
        SimplifiedMergeUtil.mergeApplication(context, sourceApps, targetAppRootDir);
        SimplifiedMergeUtil.mergeLog4j2(context);
        SimplifiedMergeUtil.mergeSpringApplication(context, sourceApps, targetAppRootDir);
        SimplifiedMergeUtil.mergeServiceRetryConfig(context, sourceApps, targetAppRootDir);
        SimplifiedDataPermissionProcessor.merge(context);
        log.info(MergeAppUtils.indentMessage(1, "\u5408\u4f75\u529f\u80fd\u914d\u7f6e\u5b8c\u6210!"));
    }

    private static void mergeApplication(MergeAppContext context, Map<String, SourceAppInfo> sourceApps, String targetAppRootDir) {
        log.info(MergeAppUtils.createSubStepTitleMessage(context, "\u914d\u7f6e", "application.properties"));
        String targetFile = SimplifiedDAPAppPropsProcessor.getMergedApplicationProperties(context);
        for (SourceAppInfo sourceApp : sourceApps.values()) {
            if (sourceApp.isTarget()) continue;
            log.info(MergeAppUtils.createSubSubStepTitleMessage(context, "\u61c9\u7528", sourceApp.getUniqueId()));
            String sourceFile = SimplifiedDAPAppPropsProcessor.getApplicationProperties(context, (SourceSimplifiedAppInfo)sourceApp);
            SimplifiedDAPAppPropsProcessor.merge(sourceFile, targetFile);
        }
        log.info(MergeAppUtils.createSubSubStepTitleMessage(context, "\u61c9\u7528", context.getTargetAppInfo().getUniqueId()));
        String sourceFile = SimplifiedDAPAppPropsProcessor.getApplicationProperties(context, (SourceSimplifiedAppInfo)context.getTargetAppInfo());
        SimplifiedDAPAppPropsProcessor.merge(sourceFile, targetFile);
        SimplifiedDAPAppPropsProcessor.finishedMerge(context);
        log.info(MergeAppUtils.indentMessage(2, "\u5408\u4f75\u5b8c\u6210!"));
    }

    private static void mergeLog4j2(MergeAppContext context) {
        log.info(MergeAppUtils.createSubStepTitleMessage(context, "\u65e5\u8a8c", "log4j2.xml"));
        String targetFile = SimplifiedLog4j2Processor.getMergedLog4j2File(context);
        ArrayList<SourceAppElement> loggers = new ArrayList<SourceAppElement>();
        for (SourceAppInfo sourceApp : context.getAppInfoMap().values()) {
            String sourceFile;
            SourceAppElement sourceAppElement;
            if (sourceApp.isTarget() || (sourceAppElement = SimplifiedLog4j2Processor.readLoggers(context, sourceApp, sourceFile = SimplifiedLog4j2Processor.getLog4j2File(context, (SourceSimplifiedAppInfo)sourceApp))) == null) continue;
            loggers.add(sourceAppElement);
        }
        String sourceFile = SimplifiedLog4j2Processor.getLog4j2File(context, (SourceSimplifiedAppInfo)context.getTargetAppInfo());
        SimplifiedLog4j2Processor.merge(context, sourceFile, targetFile, loggers);
        log.info(MergeAppUtils.indentMessage(2, "\u5408\u4f75\u5b8c\u6210!"));
    }

    private static void mergeSpringApplication(MergeAppContext context, Map<String, SourceAppInfo> sourceApps, String targetAppRootDir) {
        log.info(MergeAppUtils.createSubStepTitleMessage(context, "Spring Bean", "spring-application.xml"));
        String targetFile = SimplifiedSpringAppProcessor.getMergedSpringApplicationFile(context);
        ArrayList<Element> beanList = new ArrayList<Element>();
        ArrayList<Element> componentScanList = new ArrayList<Element>();
        for (SourceAppInfo sourceApp : sourceApps.values()) {
            String rootDir = sourceApp.getRootDir();
            if (targetAppRootDir.equals(rootDir)) continue;
            log.info(MergeAppUtils.createSubSubStepTitleMessage(context, "\u61c9\u7528", sourceApp.getUniqueId()));
            String sourceFile = SimplifiedSpringAppProcessor.getSpringApplicationFile(context, (SourceSimplifiedAppInfo)sourceApp);
            SimplifiedSpringAppProcessor.readBeanAndComponentScan(context, sourceFile, beanList, componentScanList);
        }
        String sourceFile = SimplifiedSpringAppProcessor.getSpringApplicationFile(context, (SourceSimplifiedAppInfo)context.getTargetAppInfo());
        SimplifiedSpringAppProcessor.merge(context, sourceFile, targetFile, beanList, componentScanList);
        log.info(MergeAppUtils.indentMessage(2, "\u5408\u4f75\u5b8c\u6210!"));
    }

    private static void mergeServiceRetryConfig(MergeAppContext context, Map<String, SourceAppInfo> sourceApps, String targetAppRootDir) {
        log.info(MergeAppUtils.createSubStepTitleMessage(context, "HTTP \u91cd\u8a66\u898f\u5247", "service-retry-config.json"));
        SimplifiedDAPConfigLayer[] layers = new SimplifiedDAPConfigLayer[]{SimplifiedDAPConfigLayer.PLATFORM, SimplifiedDAPConfigLayer.APPLICATION};
        int seq = 0;
        for (SimplifiedDAPConfigLayer layer : layers) {
            if (++seq == 1) {
                log.info(MergeAppUtils.indentMessage(context, "\u914d\u7f6e\u5c64: {}"), (Object)layer);
            } else {
                log.info(MergeAppUtils.indentMessage(context.getLogIndent() - 1, "\u914d\u7f6e\u5c64: {}"), (Object)layer);
            }
            String targetFile = SimplifiedServiceRetryProcessor.getMergedServiceRetryConfigFile(context, layer);
            String sourceFile = SimplifiedServiceRetryProcessor.getServiceRetryConfigFile(context, (SourceSimplifiedAppInfo)context.getTargetAppInfo(), layer);
            log.info(MergeAppUtils.createSubSubStepTitleMessage(context, "\u61c9\u7528", context.getTargetAppInfo().getUniqueId()));
            SimplifiedServiceRetryProcessor.merge(context, sourceFile, targetFile);
            for (SourceAppInfo sourceApp : sourceApps.values()) {
                if (sourceApp.isTarget()) continue;
                log.info(MergeAppUtils.createSubSubStepTitleMessage(context, "\u61c9\u7528", sourceApp.getUniqueId()));
                sourceFile = SimplifiedServiceRetryProcessor.getServiceRetryConfigFile(context, (SourceSimplifiedAppInfo)sourceApp, layer);
                SimplifiedServiceRetryProcessor.merge(context, sourceFile, targetFile);
            }
        }
        log.info(MergeAppUtils.indentMessage(2, "\u5408\u4f75\u5b8c\u6210"));
    }
}

