/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.merge;

import com.digiwin.app.merge.MergeAppContext;
import com.digiwin.app.merge.MergeAppUtils;
import com.digiwin.app.merge.pojo.MvnDependencyInfo;
import com.digiwin.app.merge.pojo.SourceAppInfo;
import com.digiwin.app.merge.processor.PomProcessor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class VersionValidUtil {
    private static final Logger log = LogManager.getLogger(VersionValidUtil.class);

    private VersionValidUtil() {
    }

    public static boolean validDapVersion(MergeAppContext context) {
        log.info(MergeAppUtils.createStepTitleMessage(context, "\u6aa2\u6e2c", "DAP \u7248\u672c"));
        boolean result = false;
        ArrayList<MvnDependencyInfo> dependencyInfoList = new ArrayList<MvnDependencyInfo>();
        for (Map.Entry<String, SourceAppInfo> entry : context.getAppInfoMap().entrySet()) {
            MvnDependencyInfo dependencyVersionInfo = PomProcessor.readDap(context, entry.getValue());
            dependencyVersionInfo.setSourceAppInfo(entry.getValue());
            dependencyInfoList.add(dependencyVersionInfo);
        }
        Map<String, List<MvnDependencyInfo>> groupByVersion = dependencyInfoList.stream().collect(Collectors.groupingBy(MvnDependencyInfo::getVersion));
        if (groupByVersion.entrySet().size() > 1) {
            log.error(MergeAppUtils.indentMessage(1, "**\u6aa2\u6e2c\u7d50\u679c** DAP\u7248\u865f\u4e0d\u4e00\u81f4!"));
            groupByVersion.forEach((k, v) -> {
                StringBuilder msg = new StringBuilder();
                msg.append(MergeAppUtils.indentMessage(2, "DAP \u7248\u672c=")).append((String)k).append(" [\u4f86\u6e90\u61c9\u7528]=");
                v.forEach(info -> msg.append(" ").append(info.getSourceAppInfo().getUniqueId()));
                log.error(msg);
            });
        } else {
            result = true;
        }
        if (result) {
            log.info(MergeAppUtils.indentMessage(1, "**\u6aa2\u6e2c\u7d50\u679c** \u6240\u6709\u7684\u61c9\u7528\u90fd\u4f7f\u7528\u7684 DAP \u7248\u672c\u70ba: " + ((MvnDependencyInfo)dependencyInfoList.get(0)).getVersion()));
        }
        return result;
    }

    public static boolean valid3rdPartyVersion(MergeAppContext context) {
        log.info(MergeAppUtils.createStepTitleMessage(context, "\u6aa2\u6e2c", "\u7b2c\u4e09\u65b9\u985e\u5eab\u7248\u672c"));
        boolean result = true;
        ArrayList<MvnDependencyInfo> dependencyInfoList = new ArrayList<MvnDependencyInfo>();
        for (Map.Entry<String, SourceAppInfo> entry : context.getAppInfoMap().entrySet()) {
            log.info(MergeAppUtils.createSubStepTitleMessage(context, "\u61c9\u7528", entry.getValue().getUniqueId()));
            List<MvnDependencyInfo> dependencies = PomProcessor.read3rdParty(context.getDevMode(), context.getWorkspace(), entry.getValue());
            for (MvnDependencyInfo dependency2 : dependencies) {
                dependency2.setSourceAppInfo(entry.getValue());
            }
            dependencyInfoList.addAll(dependencies);
        }
        Map<String, List<MvnDependencyInfo>> groupByGroupIdArtifactId = dependencyInfoList.stream().collect(Collectors.groupingBy(dependency -> dependency.getGroupId() + ":" + dependency.getArtifactId()));
        for (Map.Entry<String, List<MvnDependencyInfo>> entry : groupByGroupIdArtifactId.entrySet()) {
            List<MvnDependencyInfo> dependencies = entry.getValue();
            Map<String, List<MvnDependencyInfo>> groupByVersion = dependencies.stream().collect(Collectors.groupingBy(MvnDependencyInfo::getVersion));
            if (groupByVersion.entrySet().size() <= 1) continue;
            log.error(MergeAppUtils.indentMessage(1, "**\u6aa2\u6e2c\u7d50\u679c** \u7b2c\u4e09\u65b9\u985e\u5eab\u7248\u865f\u4e0d\u4e00\u81f4: " + entry.getKey()));
            groupByVersion.forEach((k, v) -> {
                StringBuilder msg = new StringBuilder();
                msg.append(MergeAppUtils.indentMessage(2, "\u7248\u672c=")).append((String)k).append(" [\u4f86\u6e90\u61c9\u7528]=");
                v.forEach(info -> msg.append(" ").append(info.getSourceAppInfo().getUniqueId()));
                log.error(msg);
            });
            result = false;
        }
        if (result) {
            log.info(MergeAppUtils.indentMessage(1, "**\u6aa2\u6e2c\u7d50\u679c** \u6240\u6709\u7684\u7b2c\u4e09\u65b9\u985e\u5eab\u7248\u672c\u90fd\u76f8\u540c"));
        }
        return result;
    }
}

