/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.merge.pojo;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SourceAppInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String appId;
    private String iamApToken;
    private String rootDir;
    private boolean isTarget;
    private List<String> errorList = new ArrayList<String>();

    public SourceAppInfo(String rootDir, boolean isTarget) {
        this.rootDir = rootDir;
        this.isTarget = isTarget;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getIamApToken() {
        return this.iamApToken;
    }

    public void setIamApToken(String iamApToken) {
        this.iamApToken = iamApToken;
    }

    public String getRootDir() {
        return this.rootDir;
    }

    public boolean isTarget() {
        return this.isTarget;
    }

    public String getUniqueId() {
        String targetMark = this.isTarget ? "(\u4f48\u7f72\u76ee\u6a19)" : "";
        return String.format("%s:%s%s", this.appId, this.rootDir, targetMark);
    }

    public void addError(String reason) {
        this.errorList.add(reason);
    }

    public List<String> getErrorList() {
        return Collections.unmodifiableList(this.errorList);
    }

    public boolean hasError() {
        return this.errorList.size() > 0;
    }

    public String toString() {
        return this.rootDir + ":" + this.appId + ":" + this.iamApToken;
    }
}

