/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.merge.processor;

import com.digiwin.app.merge.MergeAppContext;
import com.digiwin.app.merge.MergeAppUtils;
import com.digiwin.app.merge.enums.DevModeEnum;
import com.digiwin.app.merge.pojo.AppModuleNameInfo;
import com.digiwin.app.merge.pojo.SourceAppInfo;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class FileProcessor {
    private static final Logger log = LogManager.getLogger(FileProcessor.class);
    public static final String TARGET_ROOT_DIR = "dap-merged-app";
    public static final String DEVELOP_DIR = "develop";
    public static final String APPLICATION_DIR = "application";
    public static final String PLATFORM_DIR = "platform";
    public static final String CONF_DIR = "conf";
    public static final String THIRD_PARTY_LIBRARY_DIR = "DWThirdPartyLibrary";
    public static final String LANGUAGE_DIR = "lang";
    public static final String LIB_DIR = "lib";
    public static final String MODULE_DIR = "module";
    public static final String TARGET_DIR = "target";
    public static final String DEPENDENCY_DIR = "dependency";
    public static final String MODULE_APP_RELATION_FILE = "dap-module-app-relation.properties";

    private FileProcessor() {
    }

    public static String getTargetRootDir() {
        return TARGET_ROOT_DIR;
    }

    public static String getTargetApplicationConfDir(String workspace) {
        return workspace + File.separator + TARGET_ROOT_DIR + File.separator + APPLICATION_DIR + File.separator + CONF_DIR;
    }

    public static String getTargetConfDir(String workspace) {
        return workspace + File.separator + TARGET_ROOT_DIR + File.separator + CONF_DIR;
    }

    public static String getModuleAppRelationFile(String workspace) {
        return FileProcessor.getTargetApplicationConfDir(workspace) + File.separator + MODULE_APP_RELATION_FILE;
    }

    public static String getGroupAppRelationFile(String workspace) {
        return FileProcessor.getTargetConfDir(workspace) + File.separator + MODULE_APP_RELATION_FILE;
    }

    /*
     * WARNING - void declaration
     */
    public static void recordModuleAppMapping(MergeAppContext context, Map<String, List<AppModuleNameInfo>> moduleNameInfoMap) {
        String appId;
        Properties props = new Properties();
        props.setProperty("dap.multiple-app-env", "true");
        for (Map.Entry<String, List<AppModuleNameInfo>> entry : moduleNameInfoMap.entrySet()) {
            String sourceAppRootDir = entry.getKey();
            appId = context.getAppInfoMap().get(sourceAppRootDir).getAppId();
            String key = "dap.merged.apps." + appId + ".modules";
            String string = entry.getValue().stream().map(info -> Objects.nonNull(info.getRenamedModuleName()) ? info.getRenamedModuleName() : info.getOriginalModuleName()).collect(Collectors.joining(","));
            props.setProperty(key, string);
        }
        for (Map.Entry<String, Object> entry : context.getAppInfoMap().entrySet()) {
            SourceAppInfo sourceAppInfo = (SourceAppInfo)entry.getValue();
            appId = sourceAppInfo.getAppId();
            String iamApToken = sourceAppInfo.getIamApToken();
            props.setProperty("dap.merged.apps." + appId + ".iamApToken", iamApToken);
        }
        ArrayList<Map.Entry<Object, Object>> sortedEntries = new ArrayList<Map.Entry<Object, Object>>(props.entrySet());
        sortedEntries.sort(Comparator.comparing(e -> (String)e.getKey()));
        try {
            void var4_9;
            Path targetFile;
            String string = FileProcessor.getModuleAppRelationFile(context.getWorkspace());
            if (DevModeEnum.SIMPLIFIED == context.getDevMode()) {
                String string2 = FileProcessor.getGroupAppRelationFile(context.getWorkspace());
            }
            if (Files.notExists(targetFile = Paths.get((String)var4_9, new String[0]), new LinkOption[0])) {
                Files.createDirectories(targetFile.getParent(), new FileAttribute[0]);
                Files.createFile(targetFile, new FileAttribute[0]);
            }
            BufferedWriter writer = Files.newBufferedWriter(targetFile, StandardCharsets.UTF_8, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
            writer.write("# Module App Relation Mappings");
            writer.newLine();
            for (Map.Entry entry : sortedEntries) {
                writer.write(entry.getKey() + "=" + entry.getValue());
                writer.newLine();
            }
            writer.close();
        }
        catch (IOException iOException) {
            log.error("\u4fdd\u5b58\u6a21\u7d44\u8207\u61c9\u7528\u6620\u5c04\u4fe1\u606f\u6642\u51fa\u932f\uff1a" + iOException.getMessage());
        }
    }

    public static void jarCopier(String sourceDir, String targetDir) {
        Path sourceDirectory = Paths.get(sourceDir, new String[0]);
        Path targetDirectory = Paths.get(targetDir, new String[0]);
        try {
            Files.createDirectories(targetDirectory, new FileAttribute[0]);
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(sourceDirectory, "*.jar");){
                for (Path sourceJar : stream) {
                    String fileName = sourceJar.getFileName().toString();
                    Path targetPath = targetDirectory.resolve(fileName);
                    Files.copy(sourceJar, targetPath, StandardCopyOption.REPLACE_EXISTING);
                    log.debug("\u8907\u88fd{}\u5230{}\u3002", (Object)sourceJar, (Object)targetPath);
                }
            }
            catch (IOException e) {
                log.error("\u5408\u4f75jar\u6587\u4ef6\u6642\u51fa\u932f: ", (Throwable)e);
            }
        }
        catch (IOException e) {
            log.error("\u5408\u4f75jar\u6587\u4ef6\u6642\u51fa\u932f: ", (Throwable)e);
        }
    }

    public static void mergeMessages(MergeAppContext context, String sourceDir, String targetDir) {
        Path sourcePath = Paths.get(sourceDir, new String[0]);
        ArrayList sourceFiles = new ArrayList();
        try (Stream<Path> paths = Files.list(sourcePath);){
            Stream<Path> languageFiles = paths.filter(p -> p.toFile().isFile()).filter(p -> p.getFileName().toString().endsWith(".properties"));
            languageFiles.forEach(sourceFiles::add);
        }
        catch (IOException e2) {
            log.error(MergeAppUtils.indentMessage(context, "\u904e\u6ffe\u591a\u8a9e\u6587\u4ef6\u6642\u51fa\u932f: " + e2.getMessage()), (Throwable)e2);
        }
        try {
            for (Path sourceFile : sourceFiles) {
                String fileName = sourceFile.getFileName().toString();
                String targetFile = targetDir + File.separator + fileName;
                log.info(MergeAppUtils.indentMessage(context.getLogIndent(), "\u6587\u4ef6: " + fileName));
                Path targetFilePath = Paths.get(targetFile, new String[0]);
                if (Files.notExists(targetFilePath, new LinkOption[0])) {
                    Files.createDirectories(targetFilePath.getParent(), new FileAttribute[0]);
                    Files.createFile(targetFilePath, new FileAttribute[0]);
                }
                FileInputStream targetInputStream = new FileInputStream(targetFile);
                Properties targetProperties = new Properties();
                targetProperties.load(targetInputStream);
                targetInputStream.close();
                FileInputStream sourceInputStream = new FileInputStream(sourceFile.toFile());
                Properties sourceProperties = new Properties();
                sourceProperties.load(sourceInputStream);
                sourceInputStream.close();
                targetProperties.putAll((Map<?, ?>)sourceProperties);
                ArrayList<Map.Entry<Object, Object>> sortedEntries = new ArrayList<Map.Entry<Object, Object>>(targetProperties.entrySet());
                sortedEntries.sort(Comparator.comparing(e -> (String)e.getKey()));
                BufferedWriter writer = Files.newBufferedWriter(targetFilePath, StandardCharsets.UTF_8, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
                writer.write("# Merged Message.");
                writer.newLine();
                for (Map.Entry entry : sortedEntries) {
                    writer.write(entry.getKey() + "=" + entry.getValue());
                    writer.newLine();
                }
                writer.close();
            }
        }
        catch (IOException e3) {
            log.error(MergeAppUtils.indentMessage(context, "\u5408\u4f75\u591a\u8a9e\u8cc7\u6599\u6642\u51fa\u932f: " + e3.getMessage()), (Throwable)e3);
        }
    }
}

