/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.merge.processor;

import com.digiwin.app.merge.MergeAppContext;
import com.digiwin.app.merge.MergeAppUtils;
import com.digiwin.app.merge.ModularDAPUtils;
import com.digiwin.app.merge.SimplifiedDAPUtils;
import com.digiwin.app.merge.enums.DevModeEnum;
import com.digiwin.app.merge.exception.MergeAppException;
import com.digiwin.app.merge.pojo.MvnDependencyInfo;
import com.digiwin.app.merge.pojo.SourceAppInfo;
import com.digiwin.app.merge.pojo.SourceSimplifiedAppInfo;
import java.io.FileInputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;

public final class PomProcessor {
    private static final Logger log = LogManager.getLogger(PomProcessor.class);
    static final String THIRD_PARTY_POM_PATH = "develop/DWThirdPartyLibrary/pom.xml";
    static final String DEFAULT_GROUP_ID = "com.digiwin";
    static final String DEFAULT_ARTIFACT_ID = "dwapiplatform";
    static final String DAP_VERSION_PROPERTY = "api.version";

    private PomProcessor() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static MvnDependencyInfo readDap(MergeAppContext context, SourceAppInfo sourceAppInfo) {
        MvnDependencyInfo result = new MvnDependencyInfo();
        result.setGroupId(DEFAULT_GROUP_ID);
        result.setArtifactId(DEFAULT_ARTIFACT_ID);
        Path pomPath = DevModeEnum.SIMPLIFIED == context.getDevMode() ? SimplifiedDAPUtils.getRootPOMXmlPath((SourceSimplifiedAppInfo)sourceAppInfo) : ModularDAPUtils.getModulePOMXmlPath(context, sourceAppInfo);
        try (FileInputStream fis = new FileInputStream(pomPath.toFile());){
            MavenXpp3Reader reader = new MavenXpp3Reader();
            Model model = reader.read(fis);
            String version = model.getProperties().getProperty(DAP_VERSION_PROPERTY);
            if (Objects.isNull(version)) {
                log.warn("\u6c92\u6709\u914d\u7f6e Property: api.version, \u7121\u6cd5\u53d6\u5f97\u4f7f\u7528\u7684 DAP \u7248\u672c!");
                MvnDependencyInfo mvnDependencyInfo = null;
                return mvnDependencyInfo;
            }
            result.setVersion(version);
            return result;
        }
        catch (Exception e) {
            log.error("9,\u8b80\u53d6pom.xml\u6642\u51fa\u932f\uff1a", (Throwable)e);
        }
        return result;
    }

    public static List<MvnDependencyInfo> read3rdParty(DevModeEnum devMode, String workspace, SourceAppInfo sourceAppInfo) {
        Path pomPath;
        ArrayList<MvnDependencyInfo> list = new ArrayList<MvnDependencyInfo>();
        String sourceAppRootDir = sourceAppInfo.getRootDir();
        try {
            pomPath = Paths.get(workspace, sourceAppRootDir, THIRD_PARTY_POM_PATH);
            if (DevModeEnum.SIMPLIFIED == devMode) {
                pomPath = SimplifiedDAPUtils.getThirdPartyLibraryPOMXmlPath((SourceSimplifiedAppInfo)sourceAppInfo);
            }
            if (!Files.exists(pomPath, new LinkOption[0])) {
                log.warn("\u6587\u4ef6{}\u4e0d\u5b58\u5728\uff01\uff01\uff01", (Object)pomPath);
                return list;
            }
        }
        catch (MergeAppException mex) {
            log.warn(MergeAppUtils.indentMessage(2, mex.getMessage()));
            return list;
        }
        try (FileInputStream fis = new FileInputStream(pomPath.toFile());){
            MavenXpp3Reader reader = new MavenXpp3Reader();
            Model model = reader.read(fis);
            model.getDependencies().forEach(d -> {
                MvnDependencyInfo info = PomProcessor.createDependencyInfo(model, d);
                info.setSourceAppInfo(sourceAppInfo);
                list.add(info);
            });
        }
        catch (Exception e) {
            log.error("9,\u8b80\u53d6\u4e09\u65b9\u4f9d\u8cf4\u7684 pom.xml \u5931\u6557\u3002", (Throwable)e);
        }
        return list;
    }

    private static MvnDependencyInfo createDependencyInfo(Model mavenModel, Dependency dependency) {
        MvnDependencyInfo info = new MvnDependencyInfo();
        info.setGroupId(dependency.getGroupId());
        info.setArtifactId(dependency.getArtifactId());
        String version = PomProcessor.resolveVersion(mavenModel, dependency);
        info.setVersion(version);
        return info;
    }

    private static String resolveVersion(Model mavenModel, Dependency dependencyModel) {
        Dependency managementDependency;
        String version = dependencyModel.getVersion();
        if (version == null && (managementDependency = (Dependency)mavenModel.getDependencyManagement().getDependencies().stream().filter(dmd -> Objects.equals(dmd.getGroupId(), dependencyModel.getGroupId()) && Objects.equals(dmd.getArtifactId(), dependencyModel.getArtifactId())).findFirst().orElse(null)) != null) {
            version = managementDependency.getVersion();
        }
        if (version != null && version.startsWith("${") && version.endsWith("}")) {
            String propertyKey = version.substring(2, version.length() - 1);
            if (mavenModel.getProperties().containsKey(propertyKey)) {
                version = mavenModel.getProperties().getProperty(propertyKey);
            }
        }
        return version;
    }
}

